/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.resource;

import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PreferFileSystemResourceLoader
extends DefaultResourceLoader {
    @Nonnull
    protected Resource getResourceByPath(@Nonnull String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (r.exists()) {
            return r;
        }
        return super.getResourceByPath(path);
    }

    @Nonnull
    public Resource getResource(@Nonnull String location) {
        Constraint.isNotNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath*:")) {
            return new ClassPathResource(location.substring("classpath*:".length()), this.getClassLoader());
        }
        return super.getResource(location);
    }
}

