/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

public class AnnotationParameterNameDiscoverer
extends DefaultParameterNameDiscoverer
implements ParameterNameDiscoverer {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AnnotationParameterNameDiscoverer.class);

    @Nullable
    public String[] getParameterNames(@Nonnull Method method) {
        return super.getParameterNames(method);
    }

    @Nullable
    private String getMyAnnotation(@Nonnull Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof ParameterName)) continue;
            ParameterName param = (ParameterName)a;
            return param.name();
        }
        return null;
    }

    @Nullable
    public String[] getParameterNames(@Nonnull Constructor<?> ctor) {
        boolean isOurs;
        Annotation[][] annotationsArray = ctor.getParameterAnnotations();
        if (annotationsArray.length == 0) {
            return super.getParameterNames(ctor);
        }
        String className = ctor.getDeclaringClass().getName();
        boolean bl = isOurs = className != null && (className.startsWith("org.opensaml") || className.startsWith("net.shibboleth"));
        if (!isOurs) {
            return super.getParameterNames(ctor);
        }
        boolean allPresent = true;
        String[] names = new String[annotationsArray.length];
        for (int index = 0; index < annotationsArray.length; ++index) {
            names[index] = this.getMyAnnotation(annotationsArray[index]);
            if (names[index] != null) continue;
            allPresent = false;
        }
        if (!allPresent) {
            this.log.debug("Constructor for class '{}' with {} parameters: Not all parameters are annotated with @ParameterName", (Object)className, (Object)annotationsArray.length);
            this.log.trace("Types : {}", ctor.getParameterTypes());
            return super.getParameterNames(ctor);
        }
        this.log.trace("Constructor for class '{}' with {} parameters called {}", new Object[]{className, names.length, names});
        return names;
    }
}

