/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.util;

import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.shared.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLConstants;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class SpringSupport {
    @Nonnull
    public static final QName SPRING_BEANS_ELEMENT_NAME = new QName("http://www.springframework.org/schema/beans", "beans");
    @Nonnull
    static final Logger LOG = LoggerFactory.getLogger(SpringSupport.class);

    private SpringSupport() {
    }

    public static void parseCustomElements(@Nullable Collection<Element> elements, @Nonnull ParserContext parserContext) {
        if (elements == null) {
            return;
        }
        for (Element e : elements) {
            assert (e != null);
            SpringSupport.parseCustomElement(e, parserContext, null, false);
        }
    }

    @Nullable
    public static ManagedList<BeanDefinition> parseCustomElements(@Nullable Collection<Element> elements, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder parentBuilder) {
        if (elements == null) {
            return null;
        }
        Constraint.isNotNull((Object)parentBuilder, (String)"parentBuilder must not be null");
        ManagedList definitions = new ManagedList(elements.size());
        for (Element e : elements) {
            assert (e != null);
            definitions.add((Object)SpringSupport.parseCustomElement(e, parserContext, parentBuilder, false));
        }
        return definitions;
    }

    public static void parseLazyInitCustomElements(@Nullable Collection<Element> elements, @Nonnull ParserContext parserContext) {
        if (elements == null) {
            return;
        }
        for (Element e : elements) {
            SpringSupport.parseLazyInitCustomElement(e, parserContext);
        }
    }

    @Nullable
    public static BeanDefinition parseCustomElement(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nullable BeanDefinitionBuilder parentBuilder, boolean lazyInit) {
        AbstractBeanDefinition containingBd = parentBuilder != null ? parentBuilder.getRawBeanDefinition() : null;
        BeanDefinition def = parserContext.getDelegate().parseCustomElement(element, (BeanDefinition)containingBd);
        if (lazyInit && def != null) {
            def.setLazyInit(true);
        }
        if (null == parentBuilder) {
            return null;
        }
        return def;
    }

    public static void parseLazyInitCustomElement(@Nullable Element element, @Nonnull ParserContext parserContext) {
        if (element == null) {
            return;
        }
        SpringSupport.parseCustomElement(element, parserContext, null, true);
    }

    public static void parseNativeElement(@Nonnull Element springBeans, @Nonnull BeanDefinitionRegistry registry) {
        XmlBeanDefinitionReader definitionReader = new XmlBeanDefinitionReader(registry);
        definitionReader.setValidationMode(3);
        definitionReader.setNamespaceAware(true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)springBeans, (OutputStream)outputStream);
        definitionReader.loadBeanDefinitions(new InputSource(new ByteArrayInputStream(outputStream.toByteArray())));
    }

    @Nonnull
    public static BeanFactory createBeanFactory(@Nonnull Element springBeans) {
        if (!springBeans.hasAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart())) {
            for (Node parent = springBeans.getParentNode(); parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
                String schemaLoc = ((Element)parent).getAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart());
                if (Strings.isNullOrEmpty((String)schemaLoc)) continue;
                springBeans.setAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getPrefix() + ":" + XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart(), schemaLoc);
                break;
            }
        }
        FilesystemGenericApplicationContext ctx = new FilesystemGenericApplicationContext();
        SpringSupport.parseNativeElement(springBeans, (BeanDefinitionRegistry)ctx);
        ctx.refresh();
        return ctx.getBeanFactory();
    }

    @Nullable
    public static <T> T getBean(@Nonnull BeanFactory beanFactory, @Nonnull Class<T> clazz) {
        Object bean = null;
        try {
            bean = beanFactory.getBean(clazz);
            LOG.debug("created spring bean {}", bean);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOG.debug("no spring bean configured of type {}", clazz);
        }
        return (T)bean;
    }

    @Nonnull
    public static AbstractBeanDefinition getAttributeValueAsList(@Nonnull Attr attribute) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(StringSupport.class, (String)"stringToList");
        result.addConstructorArgValue((Object)attribute.getValue());
        result.addConstructorArgValue((Object)" \n\r\t");
        return result.getBeanDefinition();
    }

    @Nonnull
    public static AbstractBeanDefinition getStringValueAsBoolean(@Nullable String string) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(StringSupport.class, (String)"booleanOf");
        result.addConstructorArgValue((Object)string);
        return result.getBeanDefinition();
    }

    @Nonnull
    public static ManagedList<String> getElementTextContentAsManagedList(@Nullable Collection<Element> elements) {
        if (null == elements || elements.isEmpty()) {
            return new ManagedList(0);
        }
        ManagedList result = new ManagedList(elements.size());
        for (Element element : elements) {
            String textContent = StringSupport.trimOrNull((String)element.getTextContent());
            if (null == textContent) continue;
            result.add((Object)textContent);
        }
        return result;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<Locale.LanguageRange> getLanguageRange(@Nonnull HttpServletRequest request) {
        List fromBrowser = HttpServletSupport.getLanguageRange((HttpServletRequest)request);
        ArrayList<Locale.LanguageRange> outList = new ArrayList<Locale.LanguageRange>(1 + fromBrowser.size());
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            outList.add(new Locale.LanguageRange(locale.getLanguage()));
        }
        catch (Throwable t) {
            LOG.error("Could not create LanguageRange for {}, Ignoring", (Object)locale, (Object)t);
        }
        outList.addAll(fromBrowser);
        return CollectionSupport.copyToList(outList);
    }
}

