/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.primitive;

import javax.annotation.Nonnull;

import org.slf4j.Logger;

import net.shibboleth.shared.annotation.constraint.NotEmpty;


/**
 * Non-null wrappers for SLF4J logger acquisition.
 * 
 * @since 9.0.0
 */
public final class LoggerFactory {

    /** Constructor. */
    private LoggerFactory() {
        
    }

    /**
     * Get class-based logger.
     * 
     * @param claz class for logger
     * 
     * @return the logger instance
     */
    @SuppressWarnings("null")
    @Nonnull public static Logger getLogger(@Nonnull final Class<?> claz) {
        return org.slf4j.LoggerFactory.getLogger(claz);
    }

    /**
     * Get class-based logger.
     * 
     * @param category name for logger
     * 
     * @return the logger instance
     */
    @SuppressWarnings("null")
    @Nonnull public static Logger getLogger(@Nonnull @NotEmpty final String category) {
        return org.slf4j.LoggerFactory.getLogger(category);
    }

}