/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.codec;

import javax.annotation.Nonnull;

import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Stub for deprecation.
 * 
 * @deprecated
 */
@Deprecated(since="9.0.0", forRemoval=true)
public final class Base32Support {

    /** Constructor. */
    private Base32Support() {

    }

    /**
     * Base32 encodes the given binary data.
     * 
     * @param data data to encode
     * @param chunked whether the encoded data should be chunked or not
     * 
     * @return the base32 encoded data
     * @throws EncodingException when any {@link Exception} is thrown from the underlying encoder, 
     *                                  or the output is null.
     */
    @Nonnull public static String encode(@Nonnull final byte[] data, final boolean chunked) throws EncodingException {
        DeprecationSupport.warn(ObjectType.CLASS, Base32Support.class.getName(), null,
                net.shibboleth.shared.codec.Base32Support.class.getName());
        return net.shibboleth.shared.codec.Base32Support.encode(data, chunked);
    }

    /**
     * Decodes (un)chunked Base32 encoded data.
     * 
     * @param data Base32 encoded data
     * 
     * @return the decoded data
     * 
     * @throws DecodingException when an {@link Exception} is thrown from
     *                              the underlying decoder, or the output is null.
     */
    @Nonnull public static byte[] decode(@Nonnull final String data) throws DecodingException {
        DeprecationSupport.warn(ObjectType.CLASS, Base32Support.class.getName(), null,
                net.shibboleth.shared.codec.Base32Support.class.getName());
        return net.shibboleth.shared.codec.Base32Support.decode(data);
    }

}