/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.LargeVarCharWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.LargeVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.Text;

public class LargeVarCharHolderReaderImpl
extends AbstractFieldReader {
    private LargeVarCharHolder holder;

    public LargeVarCharHolderReaderImpl(LargeVarCharHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LARGEVARCHAR;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(LargeVarCharHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
    }

    @Override
    public void read(NullableLargeVarCharHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Text readText() {
        int length = (int)(this.holder.end - this.holder.start);
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        Text text = new Text();
        text.set(value);
        return text;
    }

    @Override
    public Object readObject() {
        return this.readText();
    }

    @Override
    public void copyAsValue(LargeVarCharWriter writer) {
        writer.write(this.holder);
    }
}

