/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message;

import com.google.flatbuffers.FlatBufferBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.KeyValue;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.FBSerializable;

public class FBSerializables {
    private FBSerializables() {
    }

    public static int writeAllStructsToVector(FlatBufferBuilder builder, List<? extends FBSerializable> all) {
        ArrayList<? extends FBSerializable> reversed = new ArrayList<FBSerializable>(all);
        Collections.reverse(reversed);
        for (FBSerializable fBSerializable : reversed) {
            fBSerializable.writeTo(builder);
        }
        return builder.endVector();
    }

    public static int writeKeyValues(FlatBufferBuilder builder, Map<String, String> metaData) {
        int[] metadataOffsets = new int[metaData.size()];
        Iterator<Map.Entry<String, String>> metadataIterator = metaData.entrySet().iterator();
        for (int i = 0; i < metadataOffsets.length; ++i) {
            Map.Entry<String, String> kv = metadataIterator.next();
            int keyOffset = builder.createString((CharSequence)kv.getKey());
            int valueOffset = builder.createString((CharSequence)kv.getValue());
            KeyValue.startKeyValue(builder);
            KeyValue.addKey(builder, keyOffset);
            KeyValue.addValue(builder, valueOffset);
            metadataOffsets[i] = KeyValue.endKeyValue(builder);
        }
        return Field.createCustomMetadataVector(builder, metadataOffsets);
    }
}

