/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import com.google.common.base.Strings;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.commons.logging.LogFactory;

public class SFLoggerUtil {
    private static final String NOT_PROVIDED_LOG = "not provided";
    private static final String PROVIDED_LOG = "provided";

    public static void initializeSnowflakeLogger() {
        String logger = SnowflakeUtil.systemGetProperty("net.snowflake.jdbc.loggerImpl");
        SFLoggerFactory.LoggerImpl loggerImplementation = SFLoggerFactory.LoggerImpl.fromString(logger);
        if (loggerImplementation == null) {
            loggerImplementation = SFLoggerFactory.LoggerImpl.JDK14LOGGER;
        }
        System.setProperty("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.impl.LogFactoryImpl");
        LogFactory logFactory = LogFactory.getFactory();
        switch (loggerImplementation) {
            case SLF4JLOGGER: {
                logFactory.setAttribute("org.apache.commons.logging.Log", (Object)"net.snowflake.client.log.SLF4JJCLWrapper");
                break;
            }
            default: {
                logFactory.setAttribute("org.apache.commons.logging.Log", (Object)"net.snowflake.client.log.JDK14JCLWrapper");
            }
        }
    }

    @SnowflakeJdbcInternalApi
    public static <T> String isVariableProvided(T variable) {
        if (variable instanceof String) {
            return Strings.isNullOrEmpty((String)((String)variable)) ? NOT_PROVIDED_LOG : PROVIDED_LOG;
        }
        return variable == null ? NOT_PROVIDED_LOG : PROVIDED_LOG;
    }
}

