/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.log.SFFormatter;
import net.snowflake.client.log.SFLogger;

public class JDK14Logger
implements SFLogger {
    private Logger jdkLogger;
    private Set<String> logMethods = new HashSet<String>(Arrays.asList("debug", "error", "info", "trace", "warn"));

    public JDK14Logger(String name) {
        this.jdkLogger = Logger.getLogger(name);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.jdkLogger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    @Override
    public void debug(String msg) {
        this.logInternal(Level.FINE, msg);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.logInternal(Level.FINE, msg, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logInternal(Level.FINE, msg, t);
    }

    @Override
    public void error(String msg) {
        this.logInternal(Level.SEVERE, msg);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.logInternal(Level.SEVERE, msg, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logInternal(Level.SEVERE, msg, t);
    }

    @Override
    public void info(String msg) {
        this.logInternal(Level.INFO, msg);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.logInternal(Level.INFO, msg, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logInternal(Level.INFO, msg, t);
    }

    @Override
    public void trace(String msg) {
        this.logInternal(Level.FINEST, msg);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.logInternal(Level.FINEST, msg, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logInternal(Level.FINEST, msg, t);
    }

    @Override
    public void warn(String msg) {
        this.logInternal(Level.WARNING, msg);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.logInternal(Level.WARNING, msg, arguments);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logInternal(Level.WARNING, msg, t);
    }

    private void logInternal(Level level, String msg) {
        if (this.jdkLogger.isLoggable(level)) {
            String[] source = this.findSourceInStack();
            this.jdkLogger.logp(level, source[0], source[1], msg);
        }
    }

    private void logInternal(Level level, String msg, Object ... arguments) {
        if (this.jdkLogger.isLoggable(level)) {
            String[] source = this.findSourceInStack();
            this.jdkLogger.logp(level, source[0], source[1], this.refactorString(msg), arguments);
        }
    }

    private void logInternal(Level level, String msg, Throwable t) {
        if (this.jdkLogger.isLoggable(level)) {
            String[] source = this.findSourceInStack();
            this.jdkLogger.logp(level, source[0], source[1], msg, t);
        }
    }

    public static void addHandler(Handler handler) {
        Logger snowflakeLogger = Logger.getLogger(SFFormatter.CLASS_NAME_PREFIX);
        snowflakeLogger.addHandler(handler);
    }

    public static void setLevel(Level level) {
        Logger snowflakeLogger = Logger.getLogger(SFFormatter.CLASS_NAME_PREFIX);
        snowflakeLogger.setLevel(level);
    }

    public static void disableDefaultHandler() {
        Logger snowflakeLogger = Logger.getLogger("net.snowflake");
        snowflakeLogger.setUseParentHandlers(false);
    }

    private String refactorString(String original) {
        StringBuilder sb = new StringBuilder();
        int argCount = 0;
        for (int i = 0; i < original.length(); ++i) {
            if (original.charAt(i) == '{' && i < original.length() - 1 && original.charAt(i + 1) == '}') {
                sb.append(String.format("{%d}", argCount));
                ++argCount;
                ++i;
                continue;
            }
            sb.append(original.charAt(i));
        }
        return sb.toString();
    }

    private String[] findSourceInStack() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        String[] results = new String[2];
        for (int i = 0; i < stackTraces.length; ++i) {
            if (!this.logMethods.contains(stackTraces[i].getMethodName())) continue;
            for (int j = i; j < stackTraces.length; ++j) {
                if (this.logMethods.contains(stackTraces[j].getMethodName())) continue;
                results[0] = stackTraces[j].getClassName();
                results[1] = stackTraces[j].getMethodName();
                return results;
            }
        }
        return results;
    }
}

