/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.SnowflakeDateTimeFormat;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.util.TimeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class ResultUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(ResultUtil.class);
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    private static final Map<String, Object> defaultParameters;

    public static ResultOutput processResult(ResultInput resultData) throws SnowflakeSQLException {
        JsonNode numberOfBindsNode;
        ResultOutput resultOutput = new ResultOutput();
        logger.debug("Entering processResult");
        JsonNode rootNode = resultData.resultJSON;
        SnowflakeUtil.checkErrorAndThrowException(rootNode);
        resultOutput.queryId = rootNode.path("data").path("queryId").asText();
        resultOutput.statementTypeId = rootNode.path("data").path("statementTypeId").asLong();
        resultOutput.totalRowCountTruncated = rootNode.path("data").path("totalTruncated").asBoolean();
        if (logger.isDebugEnabled()) {
            logger.debug("query id: {}", resultOutput.queryId);
        }
        resultOutput.parameters = SessionUtil.getCommonParams(rootNode.path("data").path("parameters"));
        resultOutput.columnCount = rootNode.path("data").path("rowtype").size();
        for (int i = 0; i < resultOutput.columnCount; ++i) {
            JsonNode colNode = rootNode.path("data").path("rowtype").path(i);
            SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata(colNode);
            resultOutput.resultColumnMetadata.add(columnMetadata);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Get column metadata: {}", columnMetadata.toString());
        }
        resultOutput.currentChunkRowset = rootNode.path("data").path("rowset");
        resultOutput.currentChunkRowCount = resultOutput.currentChunkRowset == null || resultOutput.currentChunkRowset.isMissingNode() ? 0 : resultOutput.currentChunkRowset.size();
        logger.debug("First chunk row count: {}", resultOutput.currentChunkRowCount);
        JsonNode chunksNode = rootNode.path("data").path("chunks");
        if (!chunksNode.isMissingNode()) {
            resultOutput.chunkCount = chunksNode.size();
            JsonNode qrmkNode = rootNode.path("data").path("qrmk");
            String qrmk = qrmkNode.isMissingNode() ? null : qrmkNode.textValue();
            JsonNode chunkHeaders = rootNode.path("data").path("chunkHeaders");
            if (resultOutput.chunkCount > 0L) {
                logger.debug("#chunks={}, initialize chunk downloader", resultOutput.chunkCount);
                int resultPrefetchThreads = 4;
                if (resultOutput.parameters.get("CLIENT_PREFETCH_THREADS") != null) {
                    resultPrefetchThreads = (Integer)resultOutput.parameters.get("CLIENT_PREFETCH_THREADS");
                }
                boolean useJsonParser = true;
                if (resultOutput.parameters.get("JDBC_USE_JSON_PARSER") != null) {
                    useJsonParser = (Boolean)resultOutput.parameters.get("JDBC_USE_JSON_PARSER");
                }
                int memoryUsage = 1536;
                if (resultOutput.parameters.get("CLIENT_MEMORY_LIMIT") != null) {
                    memoryUsage = (Integer)resultOutput.parameters.get("CLIENT_MEMORY_LIMIT");
                }
                boolean efficientChunkStorage = false;
                if (resultOutput.parameters.get("JDBC_EFFICIENT_CHUNK_STORAGE") != null) {
                    efficientChunkStorage = (Boolean)resultOutput.parameters.get("JDBC_EFFICIENT_CHUNK_STORAGE");
                }
                resultPrefetchThreads = useJsonParser && efficientChunkStorage ? Math.max(Math.min(resultPrefetchThreads, Runtime.getRuntime().availableProcessors() / 2), 2) : 1;
                resultOutput.chunkDownloader = new SnowflakeChunkDownloader(resultOutput.columnCount, chunksNode, resultPrefetchThreads, qrmk, chunkHeaders, resultData.networkTimeoutInMilli, useJsonParser, memoryUsage * 1024 * 1024, efficientChunkStorage);
            }
        }
        String sqlTimestampFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIMESTAMP_OUTPUT_FORMAT");
        resultOutput.timestampNTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_ntz", "TIMESTAMP_NTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        resultOutput.timestampLTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_ltz", "TIMESTAMP_LTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        resultOutput.timestampTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_tz", "TIMESTAMP_TZ_OUTPUT_FORMAT", sqlTimestampFormat);
        String sqlDateFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "DATE_OUTPUT_FORMAT");
        resultOutput.dateFormatter = new SnowflakeDateTimeFormat(sqlDateFormat);
        if (logger.isDebugEnabled()) {
            logger.debug("sql date format: {}, java date format: {}", sqlDateFormat, resultOutput.dateFormatter.toSimpleDateTimePattern());
        }
        String sqlTimeFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIME_OUTPUT_FORMAT");
        resultOutput.timeFormatter = new SnowflakeDateTimeFormat(sqlTimeFormat);
        if (logger.isDebugEnabled()) {
            logger.debug("sql time format: {}, java time format: {}", sqlTimeFormat, resultOutput.timeFormatter.toSimpleDateTimePattern());
        }
        String timeZoneName = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIMEZONE");
        resultOutput.timeZone = TimeZone.getTimeZone(timeZoneName);
        resultOutput.honorClientTZForTimestampNTZ = (Boolean)ResultUtil.effectiveParamValue(resultOutput.parameters, "CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ");
        logger.debug("Honoring client TZ for timestamp_ntz? {}", resultOutput.honorClientTZForTimestampNTZ);
        String binaryFmt = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "BINARY_OUTPUT_FORMAT");
        resultOutput.binaryFormatter = SFBinaryFormat.getSafeOutputFormat(binaryFmt);
        JsonNode versionNode = rootNode.path("data").path("version");
        if (!versionNode.isMissingNode()) {
            resultOutput.resultVersion = versionNode.longValue();
        }
        if (!(numberOfBindsNode = rootNode.path("data").path("numberOfBinds")).isMissingNode()) {
            resultOutput.numberOfBinds = numberOfBindsNode.intValue();
        }
        logger.debug("result version={}", resultOutput.resultVersion);
        return resultOutput;
    }

    private static Object effectiveParamValue(Map<String, Object> parameters, String paramName) {
        String upper = paramName.toUpperCase();
        Object value = parameters.get(upper);
        if (value != null) {
            return value;
        }
        value = defaultParameters.get(upper);
        if (value != null) {
            return value;
        }
        logger.debug("Unknown Common Parameter: {}", paramName);
        return null;
    }

    private static SnowflakeDateTimeFormat specializedFormatter(Map<String, Object> parameters, String id, String param, String defaultFormat) {
        String sqlFormat = SnowflakeDateTimeFormat.effectiveSpecializedTimestampFormat((String)ResultUtil.effectiveParamValue(parameters, param), defaultFormat);
        SnowflakeDateTimeFormat formatter = new SnowflakeDateTimeFormat(sqlFormat);
        if (logger.isDebugEnabled()) {
            logger.debug("sql {} format: {}, java {} format: {}", id, sqlFormat, id, formatter.toSimpleDateTimePattern());
        }
        return formatter;
    }

    public static Timestamp adjustTimestamp(Timestamp timestamp) {
        long milliToAdjust = ResultUtil.calculateMilliToAdjust(timestamp);
        if (milliToAdjust != 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("adjust timestamp by {} days", milliToAdjust / 86400000L);
            }
            Timestamp newTimestamp = new Timestamp(timestamp.getTime() + milliToAdjust);
            newTimestamp.setNanos(timestamp.getNanos());
            return newTimestamp;
        }
        return timestamp;
    }

    public static long calculateMilliToAdjust(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        if (date.getTime() < -12220156800000L) {
            if (month == 0 || month == 1 && dayOfMonth <= 28) {
                --year;
            }
            int hundreds = year / 100;
            int differenceInDays = hundreds - hundreds / 4 - 2;
            return differenceInDays * 86400000;
        }
        return 0L;
    }

    public static SFTimestamp getSFTimestamp(String timestampStr, int scale, int internalColumnType, long resultVersion, TimeZone sessionTZ, SFSession session) throws SFException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)");
        try {
            TimeUtil.TimestampType tsType = null;
            switch (internalColumnType) {
                case 93: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_NTZ;
                    break;
                }
                case 50001: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_TZ;
                    logger.trace("Handle timestamp with timezone {} encoding: {}", resultVersion > 0L ? "new" : "old", timestampStr);
                    break;
                }
                case 50000: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_LTZ;
                }
            }
            return TimeUtil.getSFTimestamp(timestampStr, scale, tsType, resultVersion, sessionTZ);
        }
        catch (IllegalArgumentException ex) {
            throw IncidentUtil.generateIncidentWithSignatureAndException(session, null, null, "Invalid timestamp value", ErrorCode.IO_ERROR, "Invalid timestamp value: " + timestampStr);
        }
    }

    public static SFTime getSFTime(String obj, int scale, SFSession session) throws SFException {
        try {
            return TimeUtil.getSFTime(obj, scale);
        }
        catch (IllegalArgumentException ex) {
            throw IncidentUtil.generateIncidentWithSignatureAndException(session, null, null, "Invalid time value", ErrorCode.INTERNAL_ERROR, "Invalid time value: " + obj);
        }
    }

    public static String getSFTimeAsString(SFTime sft, int scale, SnowflakeDateTimeFormat timeFormatter) {
        return timeFormatter.format(sft, scale);
    }

    public static String getBooleanAsString(boolean bool) {
        return bool ? "TRUE" : "FALSE";
    }

    public static String getSFTimestampAsString(SFTimestamp sfTS, int columnType, int scale, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter, SFSession session) throws SFException {
        SnowflakeDateTimeFormat formatter = columnType == 93 ? timestampNTZFormatter : (columnType == 50000 ? timestampLTZFormatter : timestampTZFormatter);
        if (formatter == null) {
            throw IncidentUtil.generateIncidentWithException(session, null, null, ErrorCode.INTERNAL_ERROR, "missing timestamp formatter");
        }
        Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(sfTS.getTimestamp());
        return formatter.format(adjustedTimestamp, sfTS.getTimeZone(), scale);
    }

    public static String getDateAsString(Date date, SnowflakeDateTimeFormat dateFormatter) {
        return dateFormatter.format((java.util.Date)date, timeZoneUTC);
    }

    private static Date adjustDate(Date date) {
        long milliToAdjust = ResultUtil.calculateMilliToAdjust(date);
        if (milliToAdjust != 0L) {
            return new Date(date.getTime() + milliToAdjust);
        }
        return date;
    }

    public static Date getDate(String str, TimeZone tz, SFSession session) throws SFException {
        try {
            long milliSecsSinceEpoch = Long.valueOf(str) * 86400000L;
            SFTimestamp tsInUTC = SFTimestamp.fromDate(new Date(milliSecsSinceEpoch), 0, TimeZone.getTimeZone("UTC"));
            SFTimestamp tsInClientTZ = tsInUTC.moveToTimeZone(tz);
            if (logger.isDebugEnabled()) {
                logger.debug("getDate: tz offset={}", tsInClientTZ.getTimeZone().getOffset(tsInClientTZ.getTime()));
            }
            Date preDate = new Date(tsInClientTZ.getTime());
            Date newDate = ResultUtil.adjustDate(preDate);
            if (logger.isDebugEnabled()) {
                logger.debug("Adjust date from {} to {}", preDate.toString(), newDate.toString());
            }
            return newDate;
        }
        catch (NumberFormatException ex) {
            SFException sfe = new SFException(ErrorCode.INTERNAL_ERROR, "Invalid date value: " + str);
            IncidentUtil.generateIncident(session, "Invalid date value", null, null, null, sfe);
            throw sfe;
        }
    }

    public static boolean getBoolean(String str) {
        return str.equalsIgnoreCase("true") || str.equals("1");
    }

    public static int calculateUpdateCount(ResultSet resultSet, long statementTypeId) throws SQLException {
        int updateCount = 0;
        if (SFStatementType.isDML(statementTypeId)) {
            while (resultSet.next()) {
                if (statementTypeId == 13824L) {
                    updateCount = (int)((long)updateCount + resultSet.getLong(4));
                    continue;
                }
                if (statementTypeId != 12544L && statementTypeId != 12800L && statementTypeId != 13056L && statementTypeId != 13312L && statementTypeId != 13568L) continue;
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    updateCount = (int)((long)updateCount + resultSet.getLong(i + 1));
                }
            }
        } else {
            updateCount = SFStatementType.isDDL(statementTypeId) ? 0 : -1;
        }
        return updateCount;
    }

    public static int listSearchCaseInsensitive(List<String> source, String target) {
        for (int i = 0; i < source.size(); ++i) {
            if (!target.equalsIgnoreCase(source.get(i))) continue;
            return i;
        }
        return -1;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TIMEZONE", "America/Los_Angeles");
        map.put("TIMESTAMP_OUTPUT_FORMAT", "DY, DD MON YYYY HH24:MI:SS TZHTZM");
        map.put("TIMESTAMP_NTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_LTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_TZ_OUTPUT_FORMAT", "");
        map.put("DATE_OUTPUT_FORMAT", "YYYY-MM-DD");
        map.put("TIME_OUTPUT_FORMAT", "HH24:MI:SS");
        map.put("CLIENT_RESULT_PREFETCH_SLOTS", 2);
        map.put("CLIENT_RESULT_PREFETCH_THREADS", 1);
        map.put("CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ", Boolean.TRUE);
        map.put("JDBC_EXECUTE_RETURN_COUNT_FOR_DML", Boolean.FALSE);
        map.put("CLIENT_DISABLE_INCIDENTS", Boolean.TRUE);
        map.put("BINARY_OUTPUT_FORMAT", "HEX");
        defaultParameters = map;
    }

    public static class ResultOutput {
        long chunkCount;
        String queryId;
        long statementTypeId;
        boolean totalRowCountTruncated;
        Map<String, Object> parameters = new HashMap<String, Object>();
        int columnCount;
        private List<SnowflakeColumnMetadata> resultColumnMetadata = new ArrayList<SnowflakeColumnMetadata>();
        private JsonNode currentChunkRowset = null;
        int currentChunkRowCount;
        long resultVersion;
        int numberOfBinds;
        SnowflakeChunkDownloader chunkDownloader;
        SnowflakeDateTimeFormat timestampNTZFormatter;
        SnowflakeDateTimeFormat timestampLTZFormatter;
        SnowflakeDateTimeFormat timestampTZFormatter;
        SnowflakeDateTimeFormat dateFormatter;
        SnowflakeDateTimeFormat timeFormatter;
        TimeZone timeZone;
        boolean honorClientTZForTimestampNTZ;
        SFBinaryFormat binaryFormatter;

        public long getChunkCount() {
            return this.chunkCount;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public long getStatementTypeId() {
            return this.statementTypeId;
        }

        public boolean isTotalRowCountTruncated() {
            return this.totalRowCountTruncated;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public List<SnowflakeColumnMetadata> getResultColumnMetadata() {
            return this.resultColumnMetadata;
        }

        public JsonNode getAndClearCurrentChunkRowset() {
            JsonNode currentChunkRowset = this.currentChunkRowset;
            this.currentChunkRowset = null;
            return currentChunkRowset;
        }

        public int getCurrentChunkRowCount() {
            return this.currentChunkRowCount;
        }

        public long getResultVersion() {
            return this.resultVersion;
        }

        public int getNumberOfBinds() {
            return this.numberOfBinds;
        }

        public SnowflakeChunkDownloader getChunkDownloader() {
            return this.chunkDownloader;
        }

        public SnowflakeDateTimeFormat getTimestampNTZFormatter() {
            return this.timestampNTZFormatter;
        }

        public SnowflakeDateTimeFormat getTimestampLTZFormatter() {
            return this.timestampLTZFormatter;
        }

        public SnowflakeDateTimeFormat getTimestampTZFormatter() {
            return this.timestampTZFormatter;
        }

        public SnowflakeDateTimeFormat getDateFormatter() {
            return this.dateFormatter;
        }

        public SnowflakeDateTimeFormat getTimeFormatter() {
            return this.timeFormatter;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public boolean isHonorClientTZForTimestampNTZ() {
            return this.honorClientTZForTimestampNTZ;
        }

        public SFBinaryFormat getBinaryFormatter() {
            return this.binaryFormatter;
        }
    }

    public static class ResultInput {
        JsonNode resultJSON;
        int connectionTimeout;
        int socketTimeout;
        int networkTimeoutInMilli;
        boolean useProxy;

        public ResultInput setResultJSON(JsonNode resultJSON) {
            this.resultJSON = resultJSON;
            return this;
        }

        public ResultInput setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public ResultInput setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ResultInput setNetworkTimeoutInMilli(int networkTimeoutInMilli) {
            this.networkTimeoutInMilli = networkTimeoutInMilli;
            return this;
        }

        public ResultInput setUseProxy(boolean useProxy) {
            this.useProxy = useProxy;
            return this;
        }
    }
}

