/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import net.snowflake.client.core.EventHandler;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.LoginInfoDTO;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFFormatter;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeDriver
implements Driver {
    public static Handler fileHandler = null;
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeDriver.class);
    private static final String JDBC_PROTOCOL = "jdbc:snowflake://";
    private static final String JDBC_PROTOCOL_REGEX = "jdbc:snowflake://([a-zA-Z_\\-0-9\\.]+(:\\d+)?)?(/?(\\?\\w+=\\w+)?(\\&\\w+=\\w+)*)?";
    public static SnowflakeDriver INSTANCE = null;
    private static final DriverPropertyInfo[] EMPTY_INFO = new DriverPropertyInfo[0];
    public static String implementVersion = null;
    public static Long svnRevision = null;
    public static int majorVersion = 0;
    public static int minorVersion = 0;
    public static long changeVersion = 0L;
    protected static boolean disableIncidents = false;

    private static void initializeClientVersionFromManifest() {
        try {
            String[] versionBreakdown;
            implementVersion = LoginInfoDTO.getLatestJDBCAppVersion();
            logger.debug("implement version: {}", implementVersion);
            if (implementVersion != null) {
                versionBreakdown = implementVersion.split("\\.");
                if (versionBreakdown == null || versionBreakdown.length != 3) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid implementation version: " + implementVersion);
                }
            } else {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Null implementation version");
            }
            majorVersion = Integer.parseInt(versionBreakdown[0]);
            minorVersion = Integer.parseInt(versionBreakdown[1]);
            changeVersion = Long.parseLong(versionBreakdown[2]);
            logger.debug("implementation_version = {}", implementVersion);
            logger.debug("major version = {}", majorVersion);
            logger.debug("minor version = {}", minorVersion);
            logger.debug("change version = {}", changeVersion);
        }
        catch (Exception ex) {
            logger.error("Exception encountered when retrieving client version attributes: {}", ex.getMessage());
        }
        try {
            if (SnowflakeConnectionV1.class.getProtectionDomain() == null || SnowflakeConnectionV1.class.getProtectionDomain().getCodeSource() == null || SnowflakeConnectionV1.class.getProtectionDomain().getCodeSource().getLocation() == null) {
                logger.debug("Couldn't get code source location");
                return;
            }
            URI jarURI = SnowflakeConnectionV1.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            logger.debug("jar uri: {}, to_url: {}", jarURI.getPath(), jarURI.toURL());
            if (jarURI == null || jarURI.getPath() == null || !jarURI.getPath().endsWith(".jar")) {
                logger.debug("couldn't determine code source");
                return;
            }
            URL jarURL = jarURI.toURL();
            if (jarURL == null) {
                logger.debug("null jar URL");
                return;
            }
            InputStream is = jarURL.openStream();
            if (is == null) {
                logger.debug("Can not open snowflake-jdbc.jar: " + jarURI.getPath());
                return;
            }
            JarInputStream jarStream = new JarInputStream(is);
            Manifest mf = jarStream.getManifest();
            if (mf == null) {
                logger.debug("Manifest not found from snowflake-jdbc.jar");
                return;
            }
            Attributes mainAttribs = mf.getMainAttributes();
            if (mainAttribs == null) {
                logger.debug("mainAttribs null from the manifest in snowflake-jdbc.jar");
                return;
            }
            if (mainAttribs.getValue("SVN-Revision") == null) {
                logger.debug("SVN-Revision is null");
                return;
            }
            svnRevision = Long.valueOf(mainAttribs.getValue("SVN-Revision"));
            logger.debug("svn_revision = " + svnRevision);
        }
        catch (Throwable ex) {
            logger.debug("Exception encountered when retrieving client svn revision attribute from manifest: " + ex.getMessage());
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.indexOf("/?") > 0 ? Pattern.matches(JDBC_PROTOCOL_REGEX, url.substring(0, url.indexOf("/?"))) : Pattern.matches(JDBC_PROTOCOL_REGEX, url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            return new SnowflakeConnectionV1(url, info);
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return EMPTY_INFO;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public static boolean isDisableIncidents() {
        return disableIncidents;
    }

    public static void setDisableIncidents(boolean throttleIncidents) {
        if (throttleIncidents) {
            logger.trace("setting throttle incidents");
        }
        disableIncidents = throttleIncidents;
    }

    private static boolean hasLoggingConfig() {
        String JRE = System.getProperty("java.home");
        String filePath = JRE + "/lib/logging.properties";
        File file = new File(filePath);
        if (file.exists()) {
            return true;
        }
        String configClass = System.getProperty("java.util.logging.config.class");
        String configFile = System.getProperty("java.util.logging.config.file");
        return configClass != null || configFile != null;
    }

    static {
        try {
            INSTANCE = new SnowflakeDriver();
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Unable to register " + SnowflakeDriver.class.getName(), ex);
        }
        try {
            String loggerImpl = System.getProperty("net.snowflake.jdbc.loggerImpl");
            EventUtil.initEventHandlerInstance(1000, 10000);
            EventHandler eventHandler = EventUtil.getEventHandlerInstance();
            if (loggerImpl == null && logger instanceof JDK14Logger) {
                String defaultLogSizeVal = System.getProperty("snowflake.jdbc.log.size");
                String defaultLogCountVal = System.getProperty("snowflake.jdbc.log.count");
                int logSize = 1000000000;
                int logCount = 2;
                if (defaultLogSizeVal != null) {
                    try {
                        logSize = Integer.parseInt(defaultLogSizeVal);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (defaultLogCountVal != null) {
                    try {
                        logCount = Integer.parseInt(defaultLogCountVal);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                fileHandler = new FileHandler("%t/snowflake_jdbc%u.log", logSize, logCount, true);
                String defaultLevelVal = System.getProperty("snowflake.jdbc.log.level");
                Level defaultLevel = Level.WARNING;
                if (defaultLevelVal != null && (defaultLevel = Level.parse(defaultLevelVal.toUpperCase())) == null) {
                    defaultLevel = Level.WARNING;
                }
                fileHandler.setLevel(Level.ALL);
                fileHandler.setFormatter(new SFFormatter());
                eventHandler.setLevel(Level.ALL);
                eventHandler.setFormatter(new SimpleFormatter());
                Logger snowflakeLogger = Logger.getLogger(SFFormatter.CLASS_NAME_PREFIX);
                snowflakeLogger.setLevel(defaultLevel);
                snowflakeLogger.addHandler(fileHandler);
                snowflakeLogger.addHandler(eventHandler);
                Logger snowflakeLoggerInformaticaV1 = Logger.getLogger("com.snowflake");
                snowflakeLoggerInformaticaV1.setLevel(defaultLevel);
                snowflakeLoggerInformaticaV1.addHandler(fileHandler);
                snowflakeLoggerInformaticaV1.addHandler(eventHandler);
                Logger snowflakeLoggerInformaticaV2 = Logger.getLogger("com.unicosolution");
                snowflakeLoggerInformaticaV2.setLevel(defaultLevel);
                snowflakeLoggerInformaticaV2.addHandler(fileHandler);
                snowflakeLoggerInformaticaV2.addHandler(eventHandler);
            } else if (loggerImpl != null && logger instanceof JDK14Logger) {
                JDK14Logger.addHandler(eventHandler);
                if (!SnowflakeDriver.hasLoggingConfig()) {
                    JDK14Logger.disableDefaultHandler();
                    ConsoleHandler console = new ConsoleHandler();
                    console.setFormatter(new SFFormatter());
                    console.setLevel(Level.WARNING);
                    JDK14Logger.addHandler(console);
                }
            }
            logger.debug("registered driver");
        }
        catch (Exception ex) {
            System.err.println("Unable to set up logging");
            ex.printStackTrace();
        }
        SnowflakeDriver.initializeClientVersionFromManifest();
    }
}

