/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

public enum SFStatementType {
    UNKNOWN(0L),
    PUT(1L),
    GET(2L),
    SELECT(4096L),
    DML(12288L),
    INSERT(12544L),
    UPDATE(12800L),
    DELETE(13056L),
    MERGE(13312L),
    MULTI_INSERT(13568L),
    COPY(13824L),
    DDL(24576L);

    private final long statementTypeId;
    private static final long LEVEL_3_RANGE = 4096L;

    private SFStatementType(long id) {
        this.statementTypeId = id;
    }

    public static SFStatementType lookUpTypeById(long id) {
        for (SFStatementType type : SFStatementType.values()) {
            if (type.getStatementTypeId() == id) {
                return type;
            }
            if (id < DDL.getStatementTypeId() || id >= DDL.getStatementTypeId() + 4096L) continue;
            return DDL;
        }
        return UNKNOWN;
    }

    public long getStatementTypeId() {
        return this.statementTypeId;
    }

    public boolean isDDL() {
        return this == DDL;
    }

    public boolean isDML() {
        return this.statementTypeId >= DML.getStatementTypeId() && this.statementTypeId < DML.getStatementTypeId() + 4096L;
    }
}

