/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import net.snowflake.client.core.FileCacheManager;
import net.snowflake.client.core.HostSpecSSD;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.KeyUpdSSD;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.OCSPTelemetryData;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFOCSPException;
import net.snowflake.client.core.SSDManager;
import net.snowflake.client.jdbc.OCSPErrorCode;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.amazonaws.Protocol;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.SdkProxyRoutePlanner;
import net.snowflake.client.jdbc.internal.apache.commons.codec.binary.Base64;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.HttpHost;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthScope;
import net.snowflake.client.jdbc.internal.apache.http.auth.UsernamePasswordCredentials;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.config.Registry;
import net.snowflake.client.jdbc.internal.apache.http.config.RegistryBuilder;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.ConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.BasicCredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultRedirectStrategy;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.ssl.SSLInitializationException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.RSASSAVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.JsonNodeType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Integer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DLSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ocsp.CertID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.Certificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.Extension;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.Extensions;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.GeneralName;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.TBSCertificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.CertificateID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.CertificateStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPReq;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPResp;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.RevokedStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.SingleResp;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DigestCalculator;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.DecorrelatedJitterBackoff;
import net.snowflake.client.util.SFPair;

public class SFTrustManager
extends X509ExtendedTrustManager {
    public static final String SF_OCSP_RESPONSE_CACHE_SERVER_URL = "SF_OCSP_RESPONSE_CACHE_SERVER_URL";
    public static final String SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED = "SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED";
    public static final String SF_OCSP_TEST_INJECT_VALIDITY_ERROR = "SF_OCSP_TEST_INJECT_VALIDITY_ERROR";
    public static final String SF_OCSP_TEST_INJECT_UNKNOWN_STATUS = "SF_OCSP_TEST_INJECT_UNKNOWN_STATUS";
    public static final String SF_OCSP_TEST_RESPONDER_URL = "SF_OCSP_TEST_RESPONDER_URL";
    public static final String SF_OCSP_TEST_OCSP_RESPONSE_CACHE_SERVER_TIMEOUT = "SF_OCSP_TEST_OCSP_RESPONSE_CACHE_SERVER_TIMEOUT";
    public static final String SF_OCSP_TEST_OCSP_RESPONDER_TIMEOUT = "SF_OCSP_TEST_OCSP_RESPONDER_TIMEOUT";
    public static final String SF_OCSP_TEST_INVALID_SIGNING_CERT = "SF_OCSP_TEST_INVALID_SIGNING_CERT";
    public static final String SF_OCSP_TEST_NO_OCSP_RESPONDER_URL = "SF_OCSP_TEST_NO_OCSP_RESPONDER_URL";
    static final String CACHE_FILE_NAME = "ocsp_response_cache.json";
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(SFTrustManager.class);
    private static final ASN1ObjectIdentifier OIDocsp = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1").intern();
    private static final ASN1ObjectIdentifier SHA1RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.5").intern();
    private static final ASN1ObjectIdentifier SHA256RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.11").intern();
    private static final ASN1ObjectIdentifier SHA384RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.12").intern();
    private static final ASN1ObjectIdentifier SHA512RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.13").intern();
    private static final String DEFAULT_SECURITY_PROVIDER_NAME = "net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String ALGORITHM_SHA1_NAME = "SHA-1";
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();
    private static final String CACHE_DIR_PROP = "net.snowflake.jdbc.ocspResponseCacheDir";
    private static final String CACHE_DIR_ENV = "SF_OCSP_RESPONSE_CACHE_DIR";
    private static final long CACHE_EXPIRATION_IN_SECONDS = 432000L;
    private static final long CACHE_FILE_LOCK_EXPIRATION_IN_SECONDS = 60L;
    private static final int DEFAULT_OCSP_CACHE_SERVER_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_OCSP_RESPONDER_CONNECTION_TIMEOUT = 10000;
    private static final String DEFAULT_OCSP_CACHE_HOST = "http://ocsp.snowflakecomputing.com";
    private static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final String BOUNCY_CASTLE_FIPS_PROVIDER = "BCFIPS";
    private static final FileCacheManager fileCacheManager;
    private static final float TOLERABLE_VALIDITY_RANGE_RATIO = 0.01f;
    private static final long MAX_CLOCK_SKEW_IN_MILLISECONDS = 900000L;
    private static final long MIN_CACHE_WARMUP_TIME_IN_MILLISECONDS = 18000000L;
    private static final long INITIAL_SLEEPING_TIME_IN_MILLISECONDS = 1000L;
    private static final long MAX_SLEEPING_TIME_IN_MILLISECONDS = 16000L;
    private static final Map<ASN1ObjectIdentifier, String> SIGNATURE_OID_TO_STRING;
    private static final Map<Integer, String> OCSP_RESPONSE_CODE_TO_STRING;
    private static final Object ROOT_CA_LOCK;
    private static final Map<OcspResponseCacheKey, SFPair<Long, String>> OCSP_RESPONSE_CACHE;
    private static final SimpleDateFormat DATE_FORMAT_UTC;
    static SSDManager ssdManager;
    static String SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN;
    private static String SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE;
    private static JcaX509CertificateConverter CONVERTER_X509;
    private static Map<Integer, Certificate> ROOT_CA;
    private static final AtomicBoolean WAS_CACHE_UPDATED;
    private static final AtomicBoolean WAS_CACHE_READ;
    private static Map<Integer, CloseableHttpClient> ocspCacheServerClient;
    public static String SF_OCSP_EVENT_TYPE_REVOKED_CERTIFICATE_ERROR;
    public static String SF_OCSP_EVENT_TYPE_VALIDATION_ERROR;
    private final X509TrustManager trustManager;
    private final X509ExtendedTrustManager exTrustManager;
    OCSPCacheServer ocspCacheServer = new OCSPCacheServer();
    private OCSPMode ocspMode;
    private static HttpClientSettingsKey proxySettingsKey;

    private static Provider instantiateSecurityProvider() {
        try {
            Class<?> klass = Class.forName(DEFAULT_SECURITY_PROVIDER_NAME);
            return (Provider)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            String errMsg = String.format("Failed to load %s, err=%s. If you use Snowflake JDBC for FIPS jar, import BouncyCastleFipsProvider in the application.", DEFAULT_SECURITY_PROVIDER_NAME, ex.getMessage());
            LOGGER.error(errMsg);
            throw new RuntimeException(errMsg);
        }
    }

    SFTrustManager(HttpClientSettingsKey key, File cacheFile) {
        this.ocspMode = key.getOcspMode();
        proxySettingsKey = key;
        this.trustManager = this.getTrustManager(KeyManagerFactory.getDefaultAlgorithm());
        this.exTrustManager = (X509ExtendedTrustManager)this.getTrustManager(KeyManagerFactory.getDefaultAlgorithm());
        this.checkNewOCSPEndpointAvailability();
        if (ssdManager.getSSDSupportStatus()) {
            this.readDirectives();
        }
        if (cacheFile != null) {
            fileCacheManager.overrideCacheFile(cacheFile);
        }
        if (!WAS_CACHE_READ.getAndSet(true)) {
            JsonNode res = fileCacheManager.readCacheFile();
            SFTrustManager.readJsonStoreCache(res);
        }
    }

    public static void deleteCache() {
        fileCacheManager.deleteCacheFile();
    }

    public static void cleanTestSystemParameters() {
        System.clearProperty(SF_OCSP_RESPONSE_CACHE_SERVER_URL);
        System.clearProperty(SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED);
        System.clearProperty(SF_OCSP_TEST_INJECT_VALIDITY_ERROR);
        System.clearProperty(SF_OCSP_TEST_INJECT_UNKNOWN_STATUS);
        System.clearProperty(SF_OCSP_TEST_RESPONDER_URL);
        System.clearProperty(SF_OCSP_TEST_OCSP_RESPONDER_TIMEOUT);
        System.clearProperty(SF_OCSP_TEST_OCSP_RESPONSE_CACHE_SERVER_TIMEOUT);
        System.clearProperty(SF_OCSP_TEST_INVALID_SIGNING_CERT);
        System.clearProperty(SF_OCSP_TEST_NO_OCSP_RESPONDER_URL);
    }

    static void resetOCSPResponseCacherServerURL(String ocspCacheServerUrl) throws IOException {
        if (ocspCacheServerUrl == null || SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN != null) {
            return;
        }
        SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = ocspCacheServerUrl;
        if (!SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE.startsWith(DEFAULT_OCSP_CACHE_HOST)) {
            URL url = new URL(SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
            SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = url.getPort() > 0 ? String.format("%s://%s:%d/retry/%s", url.getProtocol(), url.getHost(), url.getPort(), "%s/%s") : String.format("%s://%s/retry/%s", url.getProtocol(), url.getHost(), "%s/%s");
        }
    }

    private static void setOCSPResponseCacheServerURL() {
        String ocspCacheUrl = SnowflakeUtil.systemGetProperty(SF_OCSP_RESPONSE_CACHE_SERVER_URL);
        if (ocspCacheUrl != null) {
            SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = ocspCacheUrl;
        }
        try {
            ocspCacheUrl = SnowflakeUtil.systemGetEnv(SF_OCSP_RESPONSE_CACHE_SERVER_URL);
            if (ocspCacheUrl != null) {
                SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = ocspCacheUrl;
            }
        }
        catch (Throwable ex) {
            LOGGER.debug("Failed to get environment variable SF_OCSP_RESPONSE_CACHE_SERVER_URL. Ignored");
        }
        if (SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE == null) {
            SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = String.format("%s/%s", DEFAULT_OCSP_CACHE_HOST, CACHE_FILE_NAME);
        }
    }

    private static boolean useOCSPResponseCacheServer() {
        String ocspCacheServerEnabled = SnowflakeUtil.systemGetProperty(SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED);
        if (Boolean.FALSE.toString().equalsIgnoreCase(ocspCacheServerEnabled)) {
            LOGGER.debug("No OCSP Response Cache Server is used.");
            return false;
        }
        try {
            ocspCacheServerEnabled = SnowflakeUtil.systemGetEnv(SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED);
            if (Boolean.FALSE.toString().equalsIgnoreCase(ocspCacheServerEnabled)) {
                LOGGER.debug("No OCSP Response Cache Server is used.");
                return false;
            }
        }
        catch (Throwable ex) {
            LOGGER.debug("Failed to get environment variable SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED. Ignored");
        }
        return true;
    }

    private static String encodeCacheKey(OcspResponseCacheKey ocsp_cache_key) {
        try {
            SHA1DigestCalculator digest = new SHA1DigestCalculator();
            AlgorithmIdentifier algo = digest.getAlgorithmIdentifier();
            ASN1OctetString nameHash = ASN1OctetString.getInstance(ocsp_cache_key.nameHash);
            ASN1OctetString keyHash = ASN1OctetString.getInstance(ocsp_cache_key.keyHash);
            ASN1Integer snumber = new ASN1Integer(ocsp_cache_key.serialNumber);
            CertID cid = new CertID(algo, nameHash, keyHash, snumber);
            return Base64.encodeBase64String(cid.toASN1Primitive().getEncoded());
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to encode cache key to base64 encoded cert id");
            return null;
        }
    }

    private static String CertificateIDToString(CertificateID certificateID) {
        return String.format("CertID. NameHash: %s, KeyHash: %s, Serial Number: %s", SFTrustManager.byteToHexString(certificateID.getIssuerNameHash()), SFTrustManager.byteToHexString(certificateID.getIssuerKeyHash()), MessageFormat.format("{0,number,#}", certificateID.getSerialNumber()));
    }

    private static SFPair<OcspResponseCacheKey, SFPair<Long, String>> decodeCacheFromJSON(Map.Entry<String, JsonNode> elem) throws IOException {
        long currentTimeSecond = new Date().getTime() / 1000L;
        byte[] certIdDer = Base64.decodeBase64(elem.getKey());
        DLSequence rawCertId = (DLSequence)ASN1ObjectIdentifier.fromByteArray(certIdDer);
        ASN1Encodable[] rawCertIdArray = rawCertId.toArray();
        byte[] issuerNameHashDer = ((DEROctetString)rawCertIdArray[1]).getEncoded();
        byte[] issuerKeyHashDer = ((DEROctetString)rawCertIdArray[2]).getEncoded();
        BigInteger serialNumber = ((ASN1Integer)rawCertIdArray[3]).getValue();
        OcspResponseCacheKey k = new OcspResponseCacheKey(issuerNameHashDer, issuerKeyHashDer, serialNumber);
        JsonNode ocspRespBase64 = elem.getValue();
        if (!ocspRespBase64.isArray() || ocspRespBase64.size() != 2) {
            LOGGER.debug("Invalid cache file format. Ignored");
            return null;
        }
        long producedAt = ocspRespBase64.get(0).asLong();
        String ocspResp = ocspRespBase64.get(1).asText();
        if (currentTimeSecond - 432000L <= producedAt) {
            return SFPair.of(k, SFPair.of(producedAt, ocspResp));
        }
        return SFPair.of(k, SFPair.of(producedAt, null));
    }

    private static ObjectNode encodeCacheToJSON() {
        try {
            ObjectNode out = OBJECT_MAPPER.createObjectNode();
            for (Map.Entry<OcspResponseCacheKey, SFPair<Long, String>> elem : OCSP_RESPONSE_CACHE.entrySet()) {
                OcspResponseCacheKey key = elem.getKey();
                SFPair<Long, String> value0 = elem.getValue();
                long currentTimeSecond = (Long)value0.left;
                SHA1DigestCalculator digest = new SHA1DigestCalculator();
                AlgorithmIdentifier algo = digest.getAlgorithmIdentifier();
                ASN1OctetString nameHash = ASN1OctetString.getInstance(key.nameHash);
                ASN1OctetString keyHash = ASN1OctetString.getInstance(key.keyHash);
                ASN1Integer serialNumber = new ASN1Integer(key.serialNumber);
                CertID cid = new CertID(algo, nameHash, keyHash, serialNumber);
                ArrayNode vout = OBJECT_MAPPER.createArrayNode();
                vout.add(currentTimeSecond);
                vout.add((String)value0.right);
                out.set(Base64.encodeBase64String(cid.toASN1Primitive().getEncoded()), vout);
            }
            return out;
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to encode ASN1 object.");
            return null;
        }
    }

    private static synchronized void readJsonStoreCache(JsonNode m3) {
        if (m3 == null || !m3.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            LOGGER.debug("Invalid cache file format.");
            return;
        }
        try {
            Iterator<Map.Entry<String, JsonNode>> itr = m3.fields();
            while (itr.hasNext()) {
                SFPair<OcspResponseCacheKey, SFPair<Long, String>> ky = SFTrustManager.decodeCacheFromJSON(itr.next());
                if (ky != null && ky.right != null && ((SFPair)ky.right).right != null) {
                    OCSP_RESPONSE_CACHE.put((OcspResponseCacheKey)ky.left, (SFPair<Long, String>)ky.right);
                    WAS_CACHE_UPDATED.set(true);
                    continue;
                }
                if (ky == null || !OCSP_RESPONSE_CACHE.containsKey(ky.left)) continue;
                OCSP_RESPONSE_CACHE.remove(ky.left);
                WAS_CACHE_UPDATED.set(true);
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to decode the cache file");
        }
    }

    private static void verifySignature(X509CertificateHolder cert, byte[] sig, byte[] data, AlgorithmIdentifier idf) throws CertificateException {
        try {
            String algorithm = SIGNATURE_OID_TO_STRING.get(idf.getAlgorithm());
            if (algorithm == null) {
                throw new NoSuchAlgorithmException(String.format("Unsupported signature OID. OID: %s", idf));
            }
            Signature signer = Signature.getInstance(algorithm);
            X509Certificate c = CONVERTER_X509.getCertificate(cert);
            signer.initVerify(c.getPublicKey());
            signer.update(data);
            if (!signer.verify(sig)) {
                throw new CertificateEncodingException(String.format("Failed to verify the signature. Potentially the data was not generated by by the cert, %s", cert.getSubject()));
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new CertificateEncodingException("Failed to verify the signature.", ex);
        }
    }

    private static String byteToHexString(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static CloseableHttpClient getHttpClient(int timeout) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", new HttpUtil.SFConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(1);
        connectionManager.setDefaultMaxPerRoute(10);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager(connectionManager).useSystemProperties().setRedirectStrategy(new DefaultRedirectStrategy()).disableCookieManagement();
        if (proxySettingsKey.usesProxy()) {
            HttpHost proxy = new HttpHost(proxySettingsKey.getProxyHost(), proxySettingsKey.getProxyPort());
            SdkProxyRoutePlanner sdkProxyRoutePlanner = new SdkProxyRoutePlanner(proxySettingsKey.getProxyHost(), proxySettingsKey.getProxyPort(), Protocol.HTTP, proxySettingsKey.getNonProxyHosts());
            httpClientBuilder = httpClientBuilder.setProxy(proxy).setRoutePlanner(sdkProxyRoutePlanner);
            if (!Strings.isNullOrEmpty(proxySettingsKey.getProxyUser()) && !Strings.isNullOrEmpty(proxySettingsKey.getProxyPassword())) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxySettingsKey.getProxyUser(), proxySettingsKey.getProxyPassword());
                AuthScope authScope = new AuthScope(proxySettingsKey.getProxyHost(), proxySettingsKey.getProxyPort());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, credentials);
                httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        return httpClientBuilder.build();
    }

    private static long maxLong(long v1, long v2) {
        return Math.max(v1, v2);
    }

    private static long calculateTolerableVadility(Date thisUpdate, Date nextUpdate) {
        return SFTrustManager.maxLong((long)((float)(nextUpdate.getTime() - thisUpdate.getTime()) * 0.01f), 18000000L);
    }

    private static boolean isValidityRange(Date currentTime, Date thisUpdate, Date nextUpdate) {
        if (SFTrustManager.checkOCSPResponseValidityErrorParameter()) {
            return false;
        }
        long tolerableValidity = SFTrustManager.calculateTolerableVadility(thisUpdate, nextUpdate);
        return thisUpdate.getTime() - 900000L <= currentTime.getTime() && currentTime.getTime() <= nextUpdate.getTime() + tolerableValidity;
    }

    private static boolean checkOCSPResponseValidityErrorParameter() {
        String injectValidityError = SnowflakeUtil.systemGetProperty(SF_OCSP_TEST_INJECT_VALIDITY_ERROR);
        return Boolean.TRUE.toString().equalsIgnoreCase(injectValidityError);
    }

    private boolean isEnabledSystemTestParameter(String key) {
        return Boolean.TRUE.toString().equalsIgnoreCase(SnowflakeUtil.systemGetProperty(key));
    }

    private boolean isOCSPFailOpen() {
        return this.ocspMode == OCSPMode.FAIL_OPEN;
    }

    private void readDirectives() {
        KeyUpdSSD keyUpdDir = ssdManager.getKeyUpdateSSD();
        HostSpecSSD hostSpecDir = ssdManager.getHostSpecBypassSSD();
        if (keyUpdDir != null) {
            this.processKeyUpdateDirective(keyUpdDir.getIssuer(), keyUpdDir.getKeyUpdDirective());
        }
        if (hostSpecDir != null) {
            ssdManager.addToSSDCache(hostSpecDir.getHostSpecDirective());
        }
    }

    private void checkNewOCSPEndpointAvailability() {
        String new_ocsp_ept;
        try {
            new_ocsp_ept = SnowflakeUtil.systemGetEnv("SF_OCSP_ACTIVATE_NEW_ENDPOINT");
        }
        catch (Throwable ex) {
            LOGGER.debug("Could not get environment variable to check for New OCSP Endpoint Availability");
            new_ocsp_ept = SnowflakeUtil.systemGetProperty("net.snowflake.jdbc.ocsp_activate_new_endpoint");
        }
        this.ocspCacheServer.new_endpoint_enabled = new_ocsp_ept != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509TrustManager getTrustManager(String algorithm) {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
            factory.init((KeyStore)null);
            X509TrustManager ret = null;
            for (TrustManager tm : factory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                ret = (X509TrustManager)tm;
                break;
            }
            if (ret == null) {
                return null;
            }
            Object object = ROOT_CA_LOCK;
            synchronized (object) {
                if (ROOT_CA.isEmpty()) {
                    for (X509Certificate cert : ret.getAcceptedIssuers()) {
                        Certificate bcCert = Certificate.getInstance(cert.getEncoded());
                        ROOT_CA.put(bcCert.getSubject().hashCode(), bcCert);
                    }
                }
            }
            return ret;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.exTrustManager.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.exTrustManager.checkClientTrusted(chain, authType, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.exTrustManager.checkServerTrusted(chain, authType, socket);
        String host = socket.getInetAddress().getHostName();
        this.validateRevocationStatus(chain, host);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.exTrustManager.checkServerTrusted(chain, authType, sslEngine);
        this.validateRevocationStatus(chain, sslEngine.getPeerHost());
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    void validateRevocationStatus(X509Certificate[] chain, String peerHost) throws CertificateException {
        List<Certificate> bcChain = this.convertToBouncyCastleCertificate(chain);
        List<SFPair<Certificate, Certificate>> pairIssuerSubjectList = this.getPairIssuerSubject(bcChain);
        if (peerHost.startsWith("ocspssd")) {
            return;
        }
        if (this.ocspCacheServer.new_endpoint_enabled) {
            this.ocspCacheServer.resetOCSPResponseCacheServer(peerHost);
        }
        SFTrustManager.setOCSPResponseCacheServerURL();
        boolean isCached = this.isCached(pairIssuerSubjectList);
        if (SFTrustManager.useOCSPResponseCacheServer() && !isCached) {
            if (!this.ocspCacheServer.new_endpoint_enabled) {
                LOGGER.debug("Downloading OCSP response cache from the server. URL: {}", SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
            } else {
                LOGGER.debug("Downloading OCSP response cache from the server. URL: {}", this.ocspCacheServer.SF_OCSP_RESPONSE_CACHE_SERVER);
            }
            try {
                this.readOcspResponseCacheServer();
            }
            catch (SFOCSPException ex) {
                LOGGER.debug("Error downloading OCSP Response from cache server : {}.OCSP Responses will be fetched directly from the CA OCSPResponder ", ex.getMessage());
            }
        }
        this.executeRevocationStatusChecks(pairIssuerSubjectList, peerHost);
        if (WAS_CACHE_UPDATED.getAndSet(false)) {
            ObjectNode input = SFTrustManager.encodeCacheToJSON();
            fileCacheManager.writeCacheFile(input);
        }
    }

    private void executeRevocationStatusChecks(List<SFPair<Certificate, Certificate>> pairIssuerSubjectList, String peerHost) throws CertificateException {
        long currentTimeSecond = new Date().getTime() / 1000L;
        for (SFPair<Certificate, Certificate> pairIssuerSubject : pairIssuerSubjectList) {
            this.executeOneRevocationStatusCheck(pairIssuerSubject, currentTimeSecond, peerHost);
        }
    }

    private String generateFailOpenLog(String logData) {
        return "WARNING!!! Using fail-open to connect. Driver is connecting to an HTTPS endpoint without OCSP based Certificate Revocation checking as it could not obtain a valid OCSP Response to use from the CA OCSP responder. Details: \n" + logData;
    }

    private void executeOneRevocationStatusCheck(SFPair<Certificate, Certificate> pairIssuerSubject, long currentTimeSecond, String peerHost) throws CertificateException {
        OcspResponseCacheKey keyOcspResponse;
        OCSPReq req;
        try {
            req = this.createRequest(pairIssuerSubject);
            CertID cid = req.getRequestList()[0].getCertID().toASN1Primitive();
            keyOcspResponse = new OcspResponseCacheKey(cid.getIssuerNameHash().getEncoded(), cid.getIssuerKeyHash().getEncoded(), cid.getSerialNumber().getValue());
        }
        catch (IOException ex) {
            throw new CertificateException(ex.getMessage(), ex);
        }
        long sleepTime = 1000L;
        DecorrelatedJitterBackoff backoff = new DecorrelatedJitterBackoff(sleepTime, 16000L);
        boolean success = false;
        OCSPTelemetryData telemetryData = new OCSPTelemetryData();
        telemetryData.setSfcPeerHost(peerHost);
        telemetryData.setCertId(SFTrustManager.encodeCacheKey(keyOcspResponse));
        telemetryData.setCacheEnabled(SFTrustManager.useOCSPResponseCacheServer());
        telemetryData.setOCSPMode(this.ocspMode);
        Throwable cause = null;
        try {
            int maxRetryCounter = this.isOCSPFailOpen() ? 1 : 2;
            for (int retry = 0; retry < maxRetryCounter; ++retry) {
                try {
                    if (ssdManager.getSSDSupportStatus() && (success = this.checkSSD(keyOcspResponse, peerHost))) break;
                    SFPair<Long, String> value0 = OCSP_RESPONSE_CACHE.get(keyOcspResponse);
                    try {
                        try {
                            if (value0 == null) {
                                telemetryData.setCacheHit(false);
                                OCSPResp ocspResp = this.fetchOcspResponse(pairIssuerSubject, req, SFTrustManager.encodeCacheKey(keyOcspResponse), peerHost, telemetryData);
                                OCSP_RESPONSE_CACHE.put(keyOcspResponse, SFPair.of(currentTimeSecond, this.ocspResponseToB64(ocspResp)));
                                WAS_CACHE_UPDATED.set(true);
                                value0 = SFPair.of(currentTimeSecond, this.ocspResponseToB64(ocspResp));
                            } else {
                                telemetryData.setCacheHit(true);
                            }
                        }
                        catch (Throwable ex) {
                            LOGGER.debug("Exception occurred while trying to fetch OCSP Response - {}", ex.getMessage());
                            throw new SFOCSPException(OCSPErrorCode.OCSP_RESPONSE_FETCH_FAILURE, "Exception occurred while trying to fetch OCSP Response", ex);
                        }
                        LOGGER.debug("validating. {}", SFTrustManager.CertificateIDToString(req.getRequestList()[0].getCertID()));
                        try {
                            this.validateRevocationStatusMain(pairIssuerSubject, (String)value0.right);
                            success = true;
                            break;
                        }
                        catch (SFOCSPException ex) {
                            if (ex.getErrorCode() != OCSPErrorCode.REVOCATION_CHECK_FAILURE) {
                                throw ex;
                            }
                            if (ssdManager.getSSDSupportStatus() && this.processOCSPBypassSSD((String)value0.right, keyOcspResponse, peerHost)) {
                                success = true;
                                break;
                            }
                            throw new CertificateException(ex.getMessage(), ex);
                        }
                    }
                    catch (SFOCSPException ex) {
                        if (ex.getErrorCode() == OCSPErrorCode.CERTIFICATE_STATUS_REVOKED) {
                            throw ex;
                        }
                        throw new CertificateException(ex.getMessage(), ex);
                    }
                }
                catch (CertificateException ex) {
                    WAS_CACHE_UPDATED.set(OCSP_RESPONSE_CACHE.remove(keyOcspResponse) != null);
                    if (WAS_CACHE_UPDATED.get()) {
                        LOGGER.debug("deleting the invalid OCSP cache.");
                    }
                    cause = ex;
                    LOGGER.debug("Retrying {}/{} after sleeping {}(ms)", retry + 1, maxRetryCounter, sleepTime);
                    try {
                        if (retry + 1 >= maxRetryCounter) continue;
                        Thread.sleep(sleepTime);
                        sleepTime = backoff.nextSleepTime(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        catch (SFOCSPException ex) {
            CertificateException error = new CertificateException(ex);
            String ocspLog = telemetryData.generateTelemetry(SF_OCSP_EVENT_TYPE_REVOKED_CERTIFICATE_ERROR, error);
            LOGGER.error(ocspLog);
            throw error;
        }
        if (!success) {
            CertificateException error;
            if (cause != null) {
                error = new CertificateException("Certificate Revocation check failed. Could not retrieve OCSP Response.", cause);
                LOGGER.debug(cause.getMessage());
            } else {
                error = new CertificateException("Certificate Revocation check failed. Could not retrieve OCSP Response.");
                LOGGER.debug(error.getMessage());
            }
            String ocspLog = telemetryData.generateTelemetry(SF_OCSP_EVENT_TYPE_VALIDATION_ERROR, error);
            if (this.isOCSPFailOpen()) {
                LOGGER.error(this.generateFailOpenLog(ocspLog));
            } else {
                LOGGER.debug(ocspLog);
                throw error;
            }
        }
    }

    private boolean checkSSD(OcspResponseCacheKey keyOcspResponse, String peerHost) {
        SFPair<Long, String> resp = OCSP_RESPONSE_CACHE.get(ssdManager.getWildCardCertId());
        String hostSpecSSD = ssdManager.getSSDFromCache();
        if (hostSpecSSD != null) {
            boolean retval = this.processOCSPBypassSSD(hostSpecSSD, keyOcspResponse, peerHost);
            if (retval) {
                return true;
            }
            LOGGER.info("Unable to process Host Specific OCSP Response. Removing it from the SSD Cache");
            ssdManager.clearSSDCache();
        } else if (resp.right != null) {
            if (this.processOCSPBypassSSD((String)resp.right, ssdManager.getWildCardCertId(), "*")) {
                return true;
            }
            LOGGER.info("Found invalid wildcard SSD in cache, removing.");
            OCSP_RESPONSE_CACHE.remove(ssdManager.getWildCardCertId());
        }
        return false;
    }

    private boolean isCached(List<SFPair<Certificate, Certificate>> pairIssuerSubjectList) {
        long currentTimeSecond = new Date().getTime() / 1000L;
        boolean isCached = true;
        try {
            for (SFPair<Certificate, Certificate> pairIssuerSubject : pairIssuerSubjectList) {
                OCSPReq req = this.createRequest(pairIssuerSubject);
                CertificateID certificateId = req.getRequestList()[0].getCertID();
                LOGGER.debug(SFTrustManager.CertificateIDToString(certificateId));
                CertID cid = certificateId.toASN1Primitive();
                OcspResponseCacheKey k = new OcspResponseCacheKey(cid.getIssuerNameHash().getEncoded(), cid.getIssuerKeyHash().getEncoded(), cid.getSerialNumber().getValue());
                SFPair<Long, String> res = OCSP_RESPONSE_CACHE.get(k);
                if (res == null) {
                    LOGGER.debug("Not all OCSP responses for the certificate is in the cache.");
                    isCached = false;
                    break;
                }
                if (currentTimeSecond - 432000L > (Long)res.left) {
                    LOGGER.debug("Cache for CertID expired.");
                    isCached = false;
                    break;
                }
                try {
                    this.validateRevocationStatusMain(pairIssuerSubject, (String)res.right);
                }
                catch (SFOCSPException ex) {
                    LOGGER.debug("Cache includes invalid OCSPResponse. Will download the OCSP cache from Snowflake OCSP server");
                    isCached = false;
                }
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to encode CertID.");
        }
        return isCached;
    }

    /*
     * Loose catch block
     */
    private void readOcspResponseCacheServer() throws SFOCSPException {
        String ocspCacheServerInUse = this.ocspCacheServer.new_endpoint_enabled ? this.ocspCacheServer.SF_OCSP_RESPONSE_CACHE_SERVER : SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = ocspCacheServerClient.computeIfAbsent(this.getOCSPCacheServerConnectionTimeout(), k -> SFTrustManager.getHttpClient(this.getOCSPCacheServerConnectionTimeout()));
        try {
            URI uri = new URI(ocspCacheServerInUse);
            HttpGet get = new HttpGet(uri);
            response = httpClient.execute(get);
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                throw new IOException(String.format("Failed to get the OCSP response from the OCSP cache server: HTTP: %d", response != null ? response.getStatusLine().getStatusCode() : -1));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy(response.getEntity().getContent(), (OutputStream)out);
            JsonNode m3 = OBJECT_MAPPER.readTree(out.toByteArray());
            out.close();
            SFTrustManager.readJsonStoreCache(m3);
            LOGGER.debug("Successfully downloaded OCSP cache from the server.");
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to read the OCSP response cache from the server. Server: {}, Err: {}", ocspCacheServerInUse, ex);
            IOUtils.closeQuietly((Closeable)response);
        }
        catch (URISyntaxException ex2) {
            LOGGER.debug("Indicate that a string could not be parsed as a URI reference.");
            throw new SFOCSPException(OCSPErrorCode.INVALID_CACHE_SERVER_URL, "Invalid OCSP Cache Server URL used", ex2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(response);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)response);
    }

    private int getOCSPCacheServerConnectionTimeout() {
        int timeout = 5000;
        if (SnowflakeUtil.systemGetProperty(SF_OCSP_TEST_OCSP_RESPONSE_CACHE_SERVER_TIMEOUT) != null) {
            try {
                timeout = Integer.parseInt(SnowflakeUtil.systemGetProperty(SF_OCSP_TEST_OCSP_RESPONSE_CACHE_SERVER_TIMEOUT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timeout;
    }

    private OCSPResp fetchOcspResponse(SFPair<Certificate, Certificate> pairIssuerSubject, OCSPReq req, String cid_enc, String hname, OCSPTelemetryData telemetryData) throws CertificateEncodingException {
        OCSPResp oCSPResp;
        HttpResponse response = null;
        try {
            URL url;
            byte[] ocspReqDer = req.getEncoded();
            String ocspReqDerBase64 = Base64.encodeBase64String(ocspReqDer);
            Set<String> ocspUrls = this.getOcspUrls((Certificate)pairIssuerSubject.right);
            this.checkExistOCSPURL(ocspUrls);
            String ocspUrlStr = ocspUrls.iterator().next();
            ocspUrlStr = this.overrideOCSPURL(ocspUrlStr);
            telemetryData.setOcspUrl(ocspUrlStr);
            telemetryData.setOcspReq(ocspReqDerBase64);
            if (!this.ocspCacheServer.new_endpoint_enabled) {
                if (SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN != null) {
                    URL ocspUrl = new URL(ocspUrlStr);
                    url = new URL(String.format(SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, ocspUrl.getHost(), ocspReqDerBase64));
                } else {
                    url = new URL(String.format("%s/%s", ocspUrlStr, ocspReqDerBase64));
                }
                LOGGER.debug("not hit cache. Fetching OCSP response from CA OCSP server. {}", url);
            } else {
                url = new URL(this.ocspCacheServer.SF_OCSP_RESPONSE_RETRY_URL);
                LOGGER.debug("not hit cache. Fetching OCSP response from Snowflake OCSP Response Fetcher. {}", url);
            }
            long sleepTime = 1000L;
            DecorrelatedJitterBackoff backoff = new DecorrelatedJitterBackoff(sleepTime, 16000L);
            boolean success = false;
            int maxRetryCounter = this.isOCSPFailOpen() ? 1 : 3;
            IOException savedEx = null;
            CloseableHttpClient httpClient = ocspCacheServerClient.computeIfAbsent(this.getOCSPResponderConnectionTimeout(), k -> SFTrustManager.getHttpClient(this.getOCSPResponderConnectionTimeout()));
            for (int retry = 0; retry < maxRetryCounter; ++retry) {
                try {
                    if (!this.ocspCacheServer.new_endpoint_enabled) {
                        HttpGet get = new HttpGet(url.toString());
                        response = httpClient.execute(get);
                    } else {
                        HttpPost post = new HttpPost(url.toString());
                        post.setHeader("Content-Type", "application/json");
                        OCSPPostReqData postReqData = new OCSPPostReqData(ocspUrlStr, ocspReqDerBase64, cid_enc, hname);
                        String json_payload = OBJECT_MAPPER.writeValueAsString(postReqData);
                        post.setEntity(new StringEntity(json_payload, "utf-8"));
                        response = httpClient.execute(post);
                    }
                    boolean bl = success = response != null && response.getStatusLine().getStatusCode() == 200;
                    if (success) {
                        break;
                    }
                }
                catch (IOException ex) {
                    LOGGER.debug("Failed to reach out OCSP responder: {}", ex.getMessage());
                    savedEx = ex;
                }
                IOUtils.closeQuietly((Closeable)((Object)response));
                LOGGER.debug("Retrying {}/{} after sleeping {}(ms)", retry + 1, maxRetryCounter, sleepTime);
                try {
                    if (retry + 1 >= maxRetryCounter) continue;
                    Thread.sleep(sleepTime);
                    sleepTime = backoff.nextSleepTime(sleepTime);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (!success) {
                throw new CertificateEncodingException(String.format("Failed to get OCSP response. StatusCode: %d, URL: %s", response == null ? null : Integer.valueOf(response.getStatusLine().getStatusCode()), ocspUrlStr), savedEx);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy(response.getEntity().getContent(), (OutputStream)out);
            OCSPResp ocspResp = new OCSPResp(out.toByteArray());
            out.close();
            if (ocspResp.getStatus() != 0) {
                throw new CertificateEncodingException(String.format("Failed to get OCSP response. Status: %s", OCSP_RESPONSE_CODE_TO_STRING.get(ocspResp.getStatus())));
            }
            oCSPResp = ocspResp;
        }
        catch (IOException ex) {
            try {
                throw new CertificateEncodingException("Failed to encode object.", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(response);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)((Object)response));
        return oCSPResp;
    }

    private void checkExistOCSPURL(Set<String> ocspUrls) throws CertificateEncodingException {
        if (ocspUrls.size() == 0 || this.isEnabledSystemTestParameter(SF_OCSP_TEST_NO_OCSP_RESPONDER_URL)) {
            throw new CertificateEncodingException("No OCSP Responder URL is attached to the certificate.", new SFOCSPException(OCSPErrorCode.NO_OCSP_URL_ATTACHED, "No OCSP Responder URL is attached to the certificate."));
        }
    }

    private int getOCSPResponderConnectionTimeout() {
        int timeout = 10000;
        if (SnowflakeUtil.systemGetProperty(SF_OCSP_TEST_OCSP_RESPONDER_TIMEOUT) != null) {
            try {
                timeout = Integer.parseInt(SnowflakeUtil.systemGetProperty(SF_OCSP_TEST_OCSP_RESPONDER_TIMEOUT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timeout;
    }

    private String overrideOCSPURL(String ocspURL) {
        String ocspURLInput = SnowflakeUtil.systemGetProperty(SF_OCSP_TEST_RESPONDER_URL);
        if (ocspURLInput != null) {
            return ocspURLInput;
        }
        return ocspURL;
    }

    private void validateRevocationStatusMain(SFPair<Certificate, Certificate> pairIssuerSubject, String ocspRespB64) throws SFOCSPException {
        try {
            X509CertificateHolder signVerifyCert;
            OCSPResp ocspResp = this.b64ToOCSPResp(ocspRespB64);
            if (ocspResp == null) {
                throw new SFOCSPException(OCSPErrorCode.INVALID_OCSP_RESPONSE, "OCSP response is null. The content is invalid.");
            }
            Date currentTime = new Date();
            BasicOCSPResp basicOcspResp = (BasicOCSPResp)ocspResp.getResponseObject();
            X509CertificateHolder[] attachedCerts = basicOcspResp.getCerts();
            this.checkInvalidSigningCertTestParameter();
            if (attachedCerts.length > 0) {
                LOGGER.debug("Certificate is attached for verification. Verifying it by the issuer certificate.");
                signVerifyCert = attachedCerts[0];
                if (currentTime.after(signVerifyCert.getNotAfter()) || currentTime.before(signVerifyCert.getNotBefore())) {
                    throw new SFOCSPException(OCSPErrorCode.EXPIRED_OCSP_SIGNING_CERTIFICATE, String.format("Cert attached to OCSP Response is invalid.Current time - %sCertificate not before time - %sCertificate not after time - %s", currentTime, signVerifyCert.getNotBefore(), signVerifyCert.getNotAfter()));
                }
                try {
                    SFTrustManager.verifySignature(new X509CertificateHolder(((Certificate)pairIssuerSubject.left).getEncoded()), signVerifyCert.getSignature(), CONVERTER_X509.getCertificate(signVerifyCert).getTBSCertificate(), signVerifyCert.getSignatureAlgorithm());
                }
                catch (CertificateException ex) {
                    LOGGER.debug("OCSP Signing Certificate signature verification failed");
                    throw new SFOCSPException(OCSPErrorCode.INVALID_CERTIFICATE_SIGNATURE, "OCSP Signing Certificate signature verification failed", ex);
                }
                LOGGER.debug("Verifying OCSP signature by the attached certificate public key.");
            } else {
                LOGGER.debug("Certificate is NOT attached for verification. Verifying OCSP signature by the issuer public key.");
                signVerifyCert = new X509CertificateHolder(((Certificate)pairIssuerSubject.left).getEncoded());
            }
            try {
                SFTrustManager.verifySignature(signVerifyCert, basicOcspResp.getSignature(), basicOcspResp.getTBSResponseData(), basicOcspResp.getSignatureAlgorithmID());
            }
            catch (CertificateException ex) {
                LOGGER.debug("OCSP signature verification failed");
                throw new SFOCSPException(OCSPErrorCode.INVALID_OCSP_RESPONSE_SIGNATURE, "OCSP signature verification failed", ex);
            }
            this.validateBasicOcspResponse(currentTime, basicOcspResp);
        }
        catch (IOException | OCSPException ex) {
            throw new SFOCSPException(OCSPErrorCode.REVOCATION_CHECK_FAILURE, "Failed to check revocation status.", ex);
        }
    }

    private void checkInvalidSigningCertTestParameter() throws SFOCSPException {
        if (this.isEnabledSystemTestParameter(SF_OCSP_TEST_INVALID_SIGNING_CERT)) {
            throw new SFOCSPException(OCSPErrorCode.EXPIRED_OCSP_SIGNING_CERTIFICATE, "Cert attached to OCSP Response is invalid");
        }
    }

    private void validateBasicOcspResponse(Date currentTime, BasicOCSPResp basicOcspResp) throws SFOCSPException {
        for (SingleResp singleResps : basicOcspResp.getResponses()) {
            this.checkCertUnknownTestParameter();
            CertificateStatus certStatus = singleResps.getCertStatus();
            if (certStatus != CertificateStatus.GOOD) {
                if (certStatus instanceof RevokedStatus) {
                    int reason;
                    RevokedStatus status = (RevokedStatus)certStatus;
                    try {
                        reason = status.getRevocationReason();
                    }
                    catch (IllegalStateException ex) {
                        reason = -1;
                    }
                    Date revocationTime = status.getRevocationTime();
                    throw new SFOCSPException(OCSPErrorCode.CERTIFICATE_STATUS_REVOKED, String.format("The certificate has been revoked. Reason: %d, Time: %s", reason, DATE_FORMAT_UTC.format(revocationTime)));
                }
                throw new SFOCSPException(OCSPErrorCode.CERTIFICATE_STATUS_UNKNOWN, "Failed to validate the certificate for UNKNOWN reason.");
            }
            Date thisUpdate = singleResps.getThisUpdate();
            Date nextUpdate = singleResps.getNextUpdate();
            LOGGER.debug("Current Time: {}, This Update: {}, Next Update: {}", currentTime, thisUpdate, nextUpdate);
            if (SFTrustManager.isValidityRange(currentTime, thisUpdate, nextUpdate)) continue;
            throw new SFOCSPException(OCSPErrorCode.INVALID_OCSP_RESPONSE_VALIDITY, String.format("The OCSP response validity is out of range: Current Time: %s, This Update: %s, Next Update: %s", DATE_FORMAT_UTC.format(currentTime), DATE_FORMAT_UTC.format(thisUpdate), DATE_FORMAT_UTC.format(nextUpdate)));
        }
        LOGGER.debug("OK. Verified the certificate revocation status.");
    }

    private void checkCertUnknownTestParameter() throws SFOCSPException {
        if (this.isEnabledSystemTestParameter(SF_OCSP_TEST_INJECT_UNKNOWN_STATUS)) {
            throw new SFOCSPException(OCSPErrorCode.CERTIFICATE_STATUS_UNKNOWN, "Failed to validate the certificate for UNKNOWN reason.");
        }
    }

    private OCSPReq createRequest(SFPair<Certificate, Certificate> pairIssuerSubject) throws IOException {
        Certificate issuer = (Certificate)pairIssuerSubject.left;
        Certificate subject = (Certificate)pairIssuerSubject.right;
        OCSPReqBuilder gen = new OCSPReqBuilder();
        try {
            SHA1DigestCalculator digest = new SHA1DigestCalculator();
            X509CertificateHolder certHolder = new X509CertificateHolder(issuer.getEncoded());
            CertificateID certId = new CertificateID(digest, certHolder, subject.getSerialNumber().getValue());
            gen.addRequest(certId);
            return gen.build();
        }
        catch (OCSPException ex) {
            throw new IOException("Failed to build a OCSPReq.", ex);
        }
    }

    private List<Certificate> convertToBouncyCastleCertificate(X509Certificate[] chain) throws CertificateEncodingException {
        ArrayList<Certificate> bcChain = new ArrayList<Certificate>();
        for (X509Certificate cert : chain) {
            bcChain.add(Certificate.getInstance(cert.getEncoded()));
        }
        return bcChain;
    }

    private List<SFPair<Certificate, Certificate>> getPairIssuerSubject(List<Certificate> bcChain) throws CertificateException {
        ArrayList<SFPair<Certificate, Certificate>> pairIssuerSubject = new ArrayList<SFPair<Certificate, Certificate>>();
        int len = bcChain.size();
        for (int i = 0; i < len; ++i) {
            Certificate bcCert = bcChain.get(i);
            if (bcCert.getIssuer().equals(bcCert.getSubject())) continue;
            if (i < len - 1) {
                pairIssuerSubject.add(SFPair.of(bcChain.get(i + 1), bcChain.get(i)));
                continue;
            }
            Certificate issuer = ROOT_CA.get(bcCert.getIssuer().hashCode());
            if (issuer == null) {
                throw new CertificateException("Failed to find the root CA.", new SFOCSPException(OCSPErrorCode.NO_ROOTCA_FOUND, "Failed to find the root CA."));
            }
            pairIssuerSubject.add(SFPair.of(issuer, bcChain.get(i)));
        }
        return pairIssuerSubject;
    }

    private Set<String> getOcspUrls(Certificate bcCert) throws IOException {
        TBSCertificate bcTbsCert = bcCert.getTBSCertificate();
        Extensions bcExts = bcTbsCert.getExtensions();
        if (bcExts == null) {
            throw new IOException("Failed to get Tbs Certificate.");
        }
        HashSet<String> ocsp = new HashSet<String>();
        Enumeration en = bcExts.oids();
        while (en.hasMoreElements()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)en.nextElement();
            Extension bcExt = bcExts.getExtension(oid);
            if (!Extension.authorityInfoAccess.equals(bcExt.getExtnId())) continue;
            DLSequence seq = (DLSequence)bcExt.getParsedValue();
            for (ASN1Encodable asn : seq) {
                ASN1ObjectIdentifier key;
                ASN1Encodable[] pairOfAsn = ((DLSequence)asn).toArray();
                if (pairOfAsn.length != 2 || !OIDocsp.equals(key = (ASN1ObjectIdentifier)pairOfAsn[0])) continue;
                GeneralName gn = GeneralName.getInstance(pairOfAsn[1]);
                ocsp.add(gn.getName().toString());
            }
        }
        return ocsp;
    }

    private void processKeyUpdateDirective(String issuer, String ssd) {
        try {
            SignedJWT jwt_signed = SignedJWT.parse(ssd);
            String jwt_issuer = (String)jwt_signed.getHeader().getCustomParam("ssd_iss");
            if (!jwt_issuer.equals(issuer)) {
                LOGGER.debug("Issuer mismatch. Invalid SSD");
                return;
            }
            String ssd_pubKey = jwt_issuer.equals("dep1") ? ssdManager.getPubKey("dep1") : ssdManager.getPubKey("dep2");
            if (ssd_pubKey == null) {
                LOGGER.debug("Invalid SSD");
                return;
            }
            String publicKeyContent = ssd_pubKey.replaceAll("\\n", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.decodeBase64(publicKeyContent));
            RSAPublicKey rsaPubKey = (RSAPublicKey)kf.generatePublic(keySpecX509);
            SignedJWT jwt_token_verified = SignedJWT.parse(ssd);
            RSASSAVerifier jwsVerifier = new RSASSAVerifier(rsaPubKey);
            try {
                if (jwt_token_verified.verify(jwsVerifier)) {
                    Date nbf;
                    long cur_time = System.currentTimeMillis();
                    if (cur_time < (nbf = jwt_token_verified.getJWTClaimsSet().getNotBeforeTime()).getTime()) {
                        LOGGER.debug("The SSD token is not yet valid. Current time less than Not Before Time");
                        return;
                    }
                    float key_ver = Float.parseFloat(jwt_token_verified.getJWTClaimsSet().getStringClaim("keyVer"));
                    if ((double)key_ver <= ssdManager.getPubKeyVer(jwt_issuer)) {
                        return;
                    }
                    ssdManager.updateKey(jwt_issuer, jwt_token_verified.getJWTClaimsSet().getStringClaim("pubKey"), key_ver);
                }
            }
            catch (Throwable ex) {
                LOGGER.debug("Failed to verify JWT Token");
                throw ex;
            }
        }
        catch (Throwable ex) {
            LOGGER.debug("Failed to parse JWT Token, aborting");
        }
    }

    private boolean processOCSPBypassSSD(String ocsp_ssd, OcspResponseCacheKey cid, String hostname) {
        try {
            SignedJWT jwt_unverified = SignedJWT.parse(ocsp_ssd);
            String jwt_issuer = (String)jwt_unverified.getHeader().getCustomParam("ssd_iss");
            String ssd_pubKey = jwt_issuer.equals("dep1") ? ssdManager.getPubKey("dep1") : ssdManager.getPubKey("dep2");
            String publicKeyContent = ssd_pubKey.replaceAll("\\n", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.decodeBase64(publicKeyContent));
            RSAPublicKey rsaPubKey = (RSAPublicKey)kf.generatePublic(keySpecX509);
            SignedJWT jwt_token_verified = SignedJWT.parse(ocsp_ssd);
            RSASSAVerifier jwsVerifier = new RSASSAVerifier(rsaPubKey);
            if (jwt_token_verified.verify(jwsVerifier)) {
                String sfc_endpoint = jwt_token_verified.getJWTClaimsSet().getStringClaim("sfcEndpoint");
                String jwt_certid = jwt_token_verified.getJWTClaimsSet().getStringClaim("certId");
                Date jwt_nbf = jwt_token_verified.getJWTClaimsSet().getNotBeforeTime();
                Date jwt_exp = jwt_token_verified.getJWTClaimsSet().getExpirationTime();
                long current_ts = System.currentTimeMillis();
                if (current_ts < jwt_exp.getTime() && current_ts >= jwt_nbf.getTime()) {
                    BigInteger serialNumber;
                    byte[] issuerKeyHashDer;
                    if (!sfc_endpoint.equals("*")) {
                        String[] splitString;
                        for (String s2 : splitString = sfc_endpoint.split("\\s+")) {
                            if (!s2.equals(hostname)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (jwt_exp.getTime() - jwt_nbf.getTime() > 604800000L) {
                        return false;
                    }
                    byte[] jwt_certid_dec = Base64.decodeBase64(jwt_certid);
                    DLSequence jwt_rawCertId = (DLSequence)ASN1ObjectIdentifier.fromByteArray(jwt_certid_dec);
                    ASN1Encodable[] jwt_rawCertIdArray = jwt_rawCertId.toArray();
                    byte[] issuerNameHashDer = ((DEROctetString)jwt_rawCertIdArray[1]).getEncoded();
                    OcspResponseCacheKey k = new OcspResponseCacheKey(issuerNameHashDer, issuerKeyHashDer = ((DEROctetString)jwt_rawCertIdArray[2]).getEncoded(), serialNumber = ((ASN1Integer)jwt_rawCertIdArray[3]).getValue());
                    if (k.equals(cid)) {
                        LOGGER.debug("Found a Signed OCSP Bypass SSD for ceri id {}", cid);
                        return true;
                    }
                    LOGGER.debug("Found invalid OCSP bypass for cert id {}", cid);
                    return false;
                }
            }
            return false;
        }
        catch (Throwable ex) {
            LOGGER.debug("Failed to parse JWT Token, aborting");
            return false;
        }
    }

    private String ocspResponseToB64(OCSPResp ocspResp) {
        if (ocspResp == null) {
            return null;
        }
        try {
            return Base64.encodeBase64String(ocspResp.getEncoded());
        }
        catch (Throwable ex) {
            LOGGER.debug("Could not convert OCSP Response to Base64");
            return null;
        }
    }

    private OCSPResp b64ToOCSPResp(String ocspRespB64) {
        try {
            return new OCSPResp(Base64.decodeBase64(ocspRespB64));
        }
        catch (Throwable ex) {
            LOGGER.debug("Could not cover OCSP Response from Base64 to OCSPResp object");
            return null;
        }
    }

    static {
        SIGNATURE_OID_TO_STRING = new ConcurrentHashMap<ASN1ObjectIdentifier, String>();
        OCSP_RESPONSE_CODE_TO_STRING = new ConcurrentHashMap<Integer, String>();
        ROOT_CA_LOCK = new Object();
        OCSP_RESPONSE_CACHE = new ConcurrentHashMap<OcspResponseCacheKey, SFPair<Long, String>>();
        DATE_FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ssdManager = new SSDManager();
        CONVERTER_X509 = new JcaX509CertificateConverter();
        ROOT_CA = new ConcurrentHashMap<Integer, Certificate>();
        WAS_CACHE_UPDATED = new AtomicBoolean();
        WAS_CACHE_READ = new AtomicBoolean();
        ocspCacheServerClient = new ConcurrentHashMap<Integer, CloseableHttpClient>();
        SF_OCSP_EVENT_TYPE_REVOKED_CERTIFICATE_ERROR = "RevokedCertificateError";
        SF_OCSP_EVENT_TYPE_VALIDATION_ERROR = "OCSPValidationError";
        fileCacheManager = FileCacheManager.builder().setCacheDirectorySystemProperty(CACHE_DIR_PROP).setCacheDirectoryEnvironmentVariable(CACHE_DIR_ENV).setBaseCacheFileName(CACHE_FILE_NAME).setCacheExpirationInSeconds(432000L).setCacheFileLockExpirationInSeconds(60L).build();
        SIGNATURE_OID_TO_STRING.put(SHA1RSA, "SHA1withRSA");
        SIGNATURE_OID_TO_STRING.put(SHA256RSA, "SHA256withRSA");
        SIGNATURE_OID_TO_STRING.put(SHA384RSA, "SHA384withRSA");
        SIGNATURE_OID_TO_STRING.put(SHA512RSA, "SHA512withRSA");
        OCSP_RESPONSE_CODE_TO_STRING.put(0, "successful");
        OCSP_RESPONSE_CODE_TO_STRING.put(1, "malformedRequest");
        OCSP_RESPONSE_CODE_TO_STRING.put(2, "internalError");
        OCSP_RESPONSE_CODE_TO_STRING.put(3, "tryLater");
        OCSP_RESPONSE_CODE_TO_STRING.put(5, "sigRequired");
        OCSP_RESPONSE_CODE_TO_STRING.put(6, "unauthorized");
        if (Security.getProvider(BOUNCY_CASTLE_PROVIDER) == null && Security.getProvider(BOUNCY_CASTLE_FIPS_PROVIDER) == null) {
            Security.addProvider(SFTrustManager.instantiateSecurityProvider());
        }
        DATE_FORMAT_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    static class SHA1DigestCalculator
    implements DigestCalculator {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        SHA1DigestCalculator() {
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.bOut;
        }

        @Override
        public byte[] getDigest() {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(SFTrustManager.ALGORITHM_SHA1_NAME);
                return messageDigest.digest(bytes);
            }
            catch (NoSuchAlgorithmException ex) {
                String errMsg = String.format("Failed to instantiate the algorithm: %s. err=%s", SFTrustManager.ALGORITHM_SHA1_NAME, ex.getMessage());
                LOGGER.error(errMsg);
                throw new RuntimeException(errMsg);
            }
        }
    }

    static class OcspResponseCacheKey {
        final byte[] nameHash;
        final byte[] keyHash;
        final BigInteger serialNumber;

        OcspResponseCacheKey(byte[] nameHash, byte[] keyHash, BigInteger serialNumber) {
            this.nameHash = nameHash;
            this.keyHash = keyHash;
            this.serialNumber = serialNumber;
        }

        public int hashCode() {
            int ret = Arrays.hashCode(this.nameHash) * 37;
            ret = ret * 10 + Arrays.hashCode(this.keyHash) * 37;
            ret = ret * 10 + this.serialNumber.hashCode();
            return ret;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OcspResponseCacheKey)) {
                return false;
            }
            OcspResponseCacheKey target = (OcspResponseCacheKey)obj;
            return Arrays.equals(this.nameHash, target.nameHash) && Arrays.equals(this.keyHash, target.keyHash) && this.serialNumber.equals(target.serialNumber);
        }

        public String toString() {
            return String.format("OcspResponseCacheKey: NameHash: %s, KeyHash: %s, SerialNumber: %s", SFTrustManager.byteToHexString(this.nameHash), SFTrustManager.byteToHexString(this.keyHash), this.serialNumber.toString());
        }
    }

    private static class OCSPPostReqData {
        private String ocsp_url;
        private String ocsp_req;
        private String cert_id_enc;
        private String hostname;

        OCSPPostReqData(String ocsp_url, String ocsp_req, String cert_id_enc, String hname) {
            this.ocsp_url = ocsp_url;
            this.ocsp_req = ocsp_req;
            this.cert_id_enc = cert_id_enc;
            this.hostname = hname;
        }
    }

    static class OCSPCacheServer {
        String SF_OCSP_RESPONSE_CACHE_SERVER;
        String SF_OCSP_RESPONSE_RETRY_URL;
        boolean new_endpoint_enabled;

        OCSPCacheServer() {
        }

        void resetOCSPResponseCacheServer(String host) {
            String ocspCacheServerUrl = host.indexOf(".global.snowflakecomputing.com") > 0 ? String.format("https://ocspssd%s/%s", host.substring(host.indexOf(45)), "ocsp") : (host.indexOf(".snowflakecomputing.com") > 0 ? String.format("https://ocspssd%s/%s", host.substring(host.indexOf(46)), "ocsp") : "https://ocspssd.snowflakecomputing.com/ocsp");
            this.SF_OCSP_RESPONSE_CACHE_SERVER = String.format("%s/%s", ocspCacheServerUrl, "fetch");
            this.SF_OCSP_RESPONSE_RETRY_URL = String.format("%s/%s", ocspCacheServerUrl, "retry");
        }
    }
}

