/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.bind;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.bind.BindException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;

public class BindUploader
implements Closeable {
    private static final SFLogger logger = SFLoggerFactory.getLogger(BindUploader.class);
    private final SFBaseSession session;
    private final String stagePath;
    private boolean closed = false;
    private long inputStreamBufferSize = 0xA00000L;
    private int fileCount = 0;
    private final DateFormat timestampFormat;
    private final DateFormat dateFormat;
    private final SimpleDateFormat timeFormat;
    private final String createStageSQL;

    private BindUploader(SFBaseSession session, String stageDir) {
        this.session = session;
        this.stagePath = "@" + session.getSfConnectionHandler().getBindStageName() + "/" + stageDir;
        this.createStageSQL = "CREATE TEMPORARY STAGE IF NOT EXISTS " + session.getSfConnectionHandler().getBindStageName() + " file_format=( type=csv field_optionally_enclosed_by='\"')";
        GregorianCalendar calendarUTC = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendarUTC.clear();
        this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
        this.timestampFormat.setCalendar(calendarUTC);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormat.setCalendar(calendarUTC);
        this.timeFormat = new SimpleDateFormat("HH:mm:ss.");
        this.timeFormat.setCalendar(calendarUTC);
    }

    private synchronized String synchronizedDateFormat(String o) {
        if (o == null) {
            return null;
        }
        return this.dateFormat.format(new Date(Long.parseLong(o)));
    }

    private synchronized String synchronizedTimeFormat(String o) {
        if (o == null) {
            return null;
        }
        SFPair<Long, Integer> times = this.getNanosAndSecs(o, false);
        long sec = (Long)times.left;
        int nano = (Integer)times.right;
        Time v1 = new Time(sec * 1000L);
        String formatWithDate = this.timestampFormat.format(v1) + String.format("%09d", nano);
        return formatWithDate.substring(11);
    }

    private SFPair<Long, Integer> getNanosAndSecs(String o, boolean isNegative) {
        int nano;
        long sec;
        String inpString = o;
        if (isNegative) {
            inpString = o.substring(1);
        }
        if (inpString.length() < 10) {
            sec = 0L;
            nano = Integer.parseInt(inpString);
        } else {
            sec = Long.parseLong(inpString.substring(0, inpString.length() - 9));
            nano = Integer.parseInt(inpString.substring(inpString.length() - 9));
        }
        if (isNegative) {
            sec = -1L * sec;
            if (nano > 0) {
                nano = 1000000000 - nano;
                --sec;
            }
        }
        return SFPair.of(sec, nano);
    }

    private synchronized String synchronizedTimestampFormat(String o) {
        if (o == null) {
            return null;
        }
        boolean isNegative = o.length() > 0 && o.charAt(0) == '-';
        SFPair<Long, Integer> times = this.getNanosAndSecs(o, isNegative);
        long sec = (Long)times.left;
        int nano = (Integer)times.right;
        Timestamp v1 = new Timestamp(sec * 1000L);
        return this.timestampFormat.format(v1) + String.format("%09d", nano) + " +00:00";
    }

    public static synchronized BindUploader newInstance(SFBaseSession session, String stageDir) {
        return new BindUploader(session, stageDir);
    }

    public void upload(Map<String, ParameterBindingDTO> bindValues) throws BindException, SQLException {
        this.upload(bindValues, true);
    }

    public void upload(Map<String, ParameterBindingDTO> bindValues, boolean compressData) throws BindException, SQLException {
        if (!this.closed) {
            List<ColumnTypeDataPair> columns = this.getColumnValues(bindValues);
            List<byte[]> bindingRows = this.buildRowsAsBytes(columns);
            int startIndex = 0;
            int numBytes = 0;
            int rowNum = 0;
            this.fileCount = 0;
            while (rowNum < bindingRows.size()) {
                while ((long)numBytes < this.inputStreamBufferSize && rowNum < bindingRows.size()) {
                    numBytes += bindingRows.get(rowNum).length;
                    ++rowNum;
                }
                ByteBuffer bb = ByteBuffer.allocate(numBytes);
                for (int i = startIndex; i < rowNum; ++i) {
                    bb.put(bindingRows.get(i));
                }
                byte[] finalBytearray = bb.array();
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(finalBytearray);
                    Throwable throwable = null;
                    try {
                        String fileName = Integer.toString(++this.fileCount);
                        this.uploadStreamInternal(inputStream, fileName, compressData);
                        startIndex = rowNum;
                        numBytes = 0;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException ex) {
                    throw new BindException(String.format("Failure using inputstream to upload bind data. Message: %s", ex.getMessage()), BindException.Type.SERIALIZATION);
                }
            }
        }
    }

    private void uploadStreamInternal(InputStream inputStream, String destFileName, boolean compressData) throws SQLException, BindException {
        this.createStageIfNeeded();
        String stageName = this.stagePath;
        logger.debug("upload data from stream: stageName={}, destFileName={}", stageName, destFileName);
        if (stageName == null) {
            throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "stage name is null");
        }
        if (destFileName == null) {
            throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "stage name is null");
        }
        SFBaseStatement stmt = this.session.getSfConnectionHandler().getSFStatement();
        StringBuilder putCommand = new StringBuilder();
        putCommand.append("put file:///tmp/placeholder ");
        putCommand.append("'");
        putCommand.append(stageName);
        putCommand.append("'");
        putCommand.append(" overwrite=true");
        SFBaseFileTransferAgent transferAgent = this.session.getSfConnectionHandler().getFileTransferAgent(putCommand.toString(), stmt);
        transferAgent.setDestStagePath(this.stagePath);
        transferAgent.setSourceStream(inputStream);
        transferAgent.setDestFileNameForStreamSource(destFileName);
        transferAgent.setCompressSourceFromStream(compressData);
        transferAgent.execute();
        stmt.close();
    }

    private List<ColumnTypeDataPair> getColumnValues(Map<String, ParameterBindingDTO> bindValues) throws BindException {
        ArrayList<ColumnTypeDataPair> columns = new ArrayList<ColumnTypeDataPair>(bindValues.size());
        for (int i = 1; i <= bindValues.size(); ++i) {
            String key = Integer.toString(i);
            if (!bindValues.containsKey(key)) {
                throw new BindException(String.format("Bind map with %d columns should contain key \"%d\"", bindValues.size(), i), BindException.Type.SERIALIZATION);
            }
            ParameterBindingDTO value = bindValues.get(key);
            try {
                String type = value.getType();
                List list = (List)value.getValue();
                ArrayList<String> convertedList = new ArrayList<String>(list.size());
                if ("TIMESTAMP_LTZ".equals(type) || "TIMESTAMP_NTZ".equals(type)) {
                    for (Object e : list) {
                        convertedList.add(this.synchronizedTimestampFormat((String)e));
                    }
                } else if ("DATE".equals(type)) {
                    for (Object e : list) {
                        convertedList.add(this.synchronizedDateFormat((String)e));
                    }
                } else if ("TIME".equals(type)) {
                    for (Object e : list) {
                        convertedList.add(this.synchronizedTimeFormat((String)e));
                    }
                } else {
                    for (Object e : list) {
                        convertedList.add((String)e);
                    }
                }
                columns.add(i - 1, new ColumnTypeDataPair(type, convertedList));
                continue;
            }
            catch (ClassCastException ex) {
                throw new BindException("Value in binding DTO could not be cast to a list", BindException.Type.SERIALIZATION);
            }
        }
        return columns;
    }

    private List<byte[]> buildRowsAsBytes(List<ColumnTypeDataPair> columns) throws BindException {
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        int numColumns = columns.size();
        if (columns.get((int)0).data.isEmpty()) {
            throw new BindException("No binds found in first column", BindException.Type.SERIALIZATION);
        }
        int numRows = columns.get((int)0).data.size();
        for (int i = 0; i < numColumns; ++i) {
            int iNumRows = columns.get((int)i).data.size();
            if (columns.get((int)i).data.size() == numRows) continue;
            throw new BindException(String.format("Column %d has a different number of binds (%d) than column 1 (%d)", i, iNumRows, numRows), BindException.Type.SERIALIZATION);
        }
        for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
            String[] row = new String[numColumns];
            for (int colIdx = 0; colIdx < numColumns; ++colIdx) {
                row[colIdx] = columns.get((int)colIdx).data.get(rowIdx);
            }
            rows.add(this.createCSVRecord(row));
        }
        return rows;
    }

    private byte[] createCSVRecord(String[] data) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(SnowflakeType.escapeForCSV(data[i]));
        }
        sb.append('\n');
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStageIfNeeded() throws BindException {
        if (this.session.getArrayBindStage() != null) {
            return;
        }
        SFBaseSession sFBaseSession = this.session;
        synchronized (sFBaseSession) {
            if (this.session.getArrayBindStage() == null) {
                try {
                    SFBaseStatement statement = this.session.getSfConnectionHandler().getSFStatement();
                    statement.execute(this.createStageSQL, null, null);
                    this.session.setArrayBindStage(this.session.getSfConnectionHandler().getBindStageName());
                }
                catch (SQLException | SFException ex) {
                    this.session.setArrayBindStageThreshold(0);
                    throw new BindException(String.format("Failed to create temporary stage for array binds. %s", ex.getMessage()), BindException.Type.UPLOAD);
                }
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public void setInputStreamBufferSize(int bufferSize) {
        this.inputStreamBufferSize = bufferSize;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public String getStagePath() {
        return this.stagePath;
    }

    public static int arrayBindValueCount(Map<String, ParameterBindingDTO> bindValues) {
        if (!BindUploader.isArrayBind(bindValues)) {
            return 0;
        }
        ParameterBindingDTO bindSample = bindValues.values().iterator().next();
        List bindSampleValues = (List)bindSample.getValue();
        return bindValues.size() * bindSampleValues.size();
    }

    public static boolean isArrayBind(Map<String, ParameterBindingDTO> bindValues) {
        if (bindValues == null || bindValues.size() == 0) {
            return false;
        }
        ParameterBindingDTO bindSample = bindValues.values().iterator().next();
        return bindSample.getValue() instanceof List;
    }

    static class ColumnTypeDataPair {
        public String type;
        public List<String> data;

        ColumnTypeDataPair(String type, List<String> data) {
            this.type = type;
            this.data = data;
        }
    }
}

