/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.validate;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.ArrowBuf;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseLargeVariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseVariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ExtensionTypeVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.NullVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compare.VectorVisitor;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.DenseUnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.FixedSizeListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.LargeListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.NonNullableStructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.UnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.validate.ValidateUtil;

public class ValidateVectorDataVisitor
implements VectorVisitor<Void, Void> {
    private void validateOffsetBuffer(ValueVector vector, int valueCount) {
        if (valueCount == 0) {
            return;
        }
        ArrowBuf offsetBuffer = vector.getOffsetBuffer();
        int prevValue = offsetBuffer.getInt(0L);
        for (int i = 1; i <= valueCount; ++i) {
            int curValue = offsetBuffer.getInt(i * 4);
            ValidateUtil.validateOrThrow(curValue >= 0, "The value at position %s of the offset buffer is negative: %s.", i, curValue);
            ValidateUtil.validateOrThrow(curValue >= prevValue, "The values in positions %s and %s of the offset buffer are decreasing: %s, %s.", i - 1, i, prevValue, curValue);
            prevValue = curValue;
        }
    }

    private void validateLargeOffsetBuffer(ValueVector vector, int valueCount) {
        if (valueCount == 0) {
            return;
        }
        ArrowBuf offsetBuffer = vector.getOffsetBuffer();
        long prevValue = offsetBuffer.getLong(0L);
        for (int i = 1; i <= valueCount; ++i) {
            long curValue = offsetBuffer.getLong((long)i * 8L);
            ValidateUtil.validateOrThrow(curValue >= 0L, "The value at position %s of the large offset buffer is negative: %s.", i, curValue);
            ValidateUtil.validateOrThrow(curValue >= prevValue, "The values in positions %s and %s of the large offset buffer are decreasing: %s, %s.", i - 1, i, prevValue, curValue);
            prevValue = curValue;
        }
    }

    private void validateTypeBuffer(ArrowBuf typeBuf, int valueCount) {
        for (int i = 0; i < valueCount; ++i) {
            ValidateUtil.validateOrThrow(typeBuf.getByte(i) >= 0, "The type id at position %s is negative: %s.", i, typeBuf.getByte(i));
        }
    }

    @Override
    public Void visit(BaseFixedWidthVector vector, Void value) {
        return null;
    }

    @Override
    public Void visit(BaseVariableWidthVector vector, Void value) {
        this.validateOffsetBuffer(vector, vector.getValueCount());
        return null;
    }

    @Override
    public Void visit(BaseLargeVariableWidthVector vector, Void value) {
        this.validateLargeOffsetBuffer(vector, vector.getValueCount());
        return null;
    }

    @Override
    public Void visit(ListVector vector, Void value) {
        this.validateOffsetBuffer(vector, vector.getValueCount());
        FieldVector innerVector = vector.getDataVector();
        if (innerVector != null) {
            innerVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(FixedSizeListVector vector, Void value) {
        this.validateOffsetBuffer(vector, vector.getValueCount());
        FieldVector innerVector = vector.getDataVector();
        if (innerVector != null) {
            innerVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(LargeListVector vector, Void value) {
        this.validateLargeOffsetBuffer(vector, vector.getValueCount());
        FieldVector innerVector = vector.getDataVector();
        if (innerVector != null) {
            innerVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(NonNullableStructVector vector, Void value) {
        for (ValueVector valueVector : vector.getChildrenFromFields()) {
            valueVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(UnionVector vector, Void value) {
        this.validateTypeBuffer(vector.getTypeBuffer(), vector.getValueCount());
        for (ValueVector valueVector : vector.getChildrenFromFields()) {
            valueVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(DenseUnionVector vector, Void value) {
        this.validateTypeBuffer(vector.getTypeBuffer(), vector.getValueCount());
        for (int i = 0; i < vector.getValueCount(); ++i) {
            byte typeId;
            ValueVector subVector;
            int n = vector.getOffset(i);
            ValidateUtil.validateOrThrow(n < (subVector = vector.getVectorByType(typeId = vector.getTypeId(i))).getValueCount(), "Dense union vector offset exceeds sub-vector boundary. Vector offset %s, sub vector size %s", n, subVector.getValueCount());
        }
        for (ValueVector valueVector : vector.getChildrenFromFields()) {
            valueVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(NullVector vector, Void value) {
        return null;
    }

    @Override
    public Void visit(ExtensionTypeVector<?> vector, Void value) {
        vector.getUnderlyingVector().accept(this, (Void)value);
        return null;
    }
}

