/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.rpc;

import java.util.concurrent.ScheduledExecutorService;
import net.snowflake.client.jdbc.internal.google.api.core.ApiClock;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.Watchdog;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.WatchdogProvider;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.threeten.bp.Duration;

@BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
@InternalApi
public final class InstantiatingWatchdogProvider
implements WatchdogProvider {
    @Nullable
    private final ApiClock clock;
    @Nullable
    private final ScheduledExecutorService executor;
    @Nullable
    private final Duration checkInterval;

    public static WatchdogProvider create() {
        return new InstantiatingWatchdogProvider(null, null, null);
    }

    private InstantiatingWatchdogProvider(@Nullable ApiClock clock, @Nullable ScheduledExecutorService executor, @Nullable Duration checkInterval) {
        this.clock = clock;
        this.executor = executor;
        this.checkInterval = checkInterval;
    }

    @Override
    public boolean needsClock() {
        return this.clock == null;
    }

    @Override
    public WatchdogProvider withClock(@Nonnull ApiClock clock) {
        return new InstantiatingWatchdogProvider(Preconditions.checkNotNull(clock), this.executor, this.checkInterval);
    }

    @Override
    public boolean needsCheckInterval() {
        return this.checkInterval == null;
    }

    @Override
    public WatchdogProvider withCheckInterval(@Nonnull Duration checkInterval) {
        return new InstantiatingWatchdogProvider(this.clock, this.executor, Preconditions.checkNotNull(checkInterval));
    }

    @Override
    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Override
    public WatchdogProvider withExecutor(ScheduledExecutorService executor) {
        return new InstantiatingWatchdogProvider(this.clock, Preconditions.checkNotNull(executor), this.checkInterval);
    }

    @Override
    @Nullable
    public Watchdog getWatchdog() {
        Preconditions.checkState(!this.needsClock(), "A clock is needed");
        Preconditions.checkState(!this.needsCheckInterval(), "A check interval is needed");
        Preconditions.checkState(!this.needsExecutor(), "An executor is needed");
        if (this.checkInterval.isZero()) {
            return null;
        }
        return Watchdog.create(this.clock, this.checkInterval, this.executor);
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }
}

