/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseVariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.NullCheckingForGet;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.VarBinaryReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.VarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public final class VarBinaryVector
extends BaseVariableWidthVector {
    private final FieldReader reader = new VarBinaryReaderImpl(this);

    public VarBinaryVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.VARBINARY.getType()), allocator);
    }

    public VarBinaryVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public VarBinaryVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.VARBINARY;
    }

    public byte[] get(int index) {
        assert (index >= 0);
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        int startOffset = this.getStartOffset(index);
        int dataLength = this.offsetBuffer.getInt((long)(index + 1) * 4L) - startOffset;
        byte[] result = new byte[dataLength];
        this.valueBuffer.getBytes((long)startOffset, result, 0, dataLength);
        return result;
    }

    public byte[] getObject(int index) {
        return this.get(index);
    }

    public void get(int index, NullableVarBinaryHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.start = this.getStartOffset(index);
        holder.end = this.offsetBuffer.getInt((index + 1) * 4);
        holder.buffer = this.valueBuffer;
    }

    public void set(int index, VarBinaryHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int dataLength = holder.end - holder.start;
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, VarBinaryHolder holder) {
        assert (index >= 0);
        int dataLength = holder.end - holder.start;
        this.handleSafe(index, dataLength);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void set(int index, NullableVarBinaryHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        int startOffset = this.getStartOffset(index);
        if (holder.isSet != 0) {
            int dataLength = holder.end - holder.start;
            this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
            this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        } else {
            this.offsetBuffer.setInt((index + 1) * 4, startOffset);
        }
        this.lastSet = index;
    }

    public void setSafe(int index, NullableVarBinaryHolder holder) {
        assert (index >= 0);
        if (holder.isSet != 0) {
            int dataLength = holder.end - holder.start;
            this.handleSafe(index, dataLength);
            this.fillHoles(index);
            int startOffset = this.getStartOffset(index);
            this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
            this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        } else {
            this.fillEmpties(index + 1);
        }
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        this.lastSet = index;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((VarBinaryVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        VarBinaryVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new VarBinaryVector(ref, VarBinaryVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(VarBinaryVector to) {
            this.to = to;
        }

        @Override
        public VarBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            VarBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            VarBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, VarBinaryVector.this);
        }
    }
}

