/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.io.Closeable;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.RestSerializationException;
import net.snowflake.client.jdbc.internal.google.gson.stream.JsonReader;
import net.snowflake.client.jdbc.internal.google.gson.stream.JsonToken;
import net.snowflake.client.jdbc.internal.google.gson.stream.JsonWriter;

class ProtoMessageJsonStreamIterator
implements Closeable,
Iterator<Reader> {
    private volatile boolean arrayStarted = false;
    private final JsonReader jsonReader;
    private final PipedReader reader;
    private final PipedWriter writer;

    ProtoMessageJsonStreamIterator(Reader rawReader) throws IOException {
        this.jsonReader = new JsonReader(rawReader);
        this.reader = new PipedReader(262144);
        this.writer = new PipedWriter();
        this.writer.connect(this.reader);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.writer.close();
        this.jsonReader.close();
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.arrayStarted) {
                this.jsonReader.beginArray();
                this.arrayStarted = true;
            }
            return this.jsonReader.hasNext();
        }
        catch (IOException e) {
            throw new RestSerializationException(e);
        }
    }

    @Override
    public Reader next() {
        try {
            int nestedObjectCount = 0;
            JsonWriter jsonWriter = new JsonWriter(this.writer);
            do {
                JsonToken token = this.jsonReader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        this.jsonReader.beginArray();
                        jsonWriter.beginArray();
                        break;
                    }
                    case END_ARRAY: {
                        this.jsonReader.endArray();
                        jsonWriter.endArray();
                        break;
                    }
                    case BEGIN_OBJECT: {
                        ++nestedObjectCount;
                        this.jsonReader.beginObject();
                        jsonWriter.beginObject();
                        break;
                    }
                    case END_OBJECT: {
                        this.jsonReader.endObject();
                        jsonWriter.endObject();
                        --nestedObjectCount;
                        break;
                    }
                    case NAME: {
                        String name = this.jsonReader.nextName();
                        jsonWriter.name(name);
                        break;
                    }
                    case STRING: {
                        String s2 = this.jsonReader.nextString();
                        jsonWriter.value(s2);
                        break;
                    }
                    case NUMBER: {
                        String n = this.jsonReader.nextString();
                        jsonWriter.value(n);
                        break;
                    }
                    case BOOLEAN: {
                        boolean b = this.jsonReader.nextBoolean();
                        jsonWriter.value(b);
                        break;
                    }
                    case NULL: {
                        this.jsonReader.nextNull();
                        jsonWriter.nullValue();
                        break;
                    }
                    case END_DOCUMENT: {
                        --nestedObjectCount;
                    }
                }
            } while (nestedObjectCount > 0);
            jsonWriter.flush();
            return this.reader;
        }
        catch (IOException e) {
            throw new RestSerializationException(e);
        }
    }
}

