/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonEncoding;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.StdDateFormat;
import net.snowflake.client.jdbc.internal.yammer.metrics.Metrics;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Clock;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.VirtualMachineMetrics;
import net.snowflake.client.jdbc.internal.yammer.metrics.reporting.MetricsServlet;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class IncidentUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(IncidentUtil.class);
    public static final String TIMESTAMP = "timestamp";
    public static final String INCIDENT_INFO = "incidentInfo";
    public static final String INC_DUMP_FILE_NAME = "sf_incident_";
    public static final String INC_DUMP_FILE_EXT = ".dmp.gz";

    public static String oneLiner(Throwable thrown) {
        StackTraceElement[] stack = thrown.getStackTrace();
        String topOfStack = null;
        if (stack.length > 0) {
            topOfStack = " at " + stack[0];
        }
        return thrown.toString() + topOfStack;
    }

    public static String oneLiner(String prefix, Throwable thrown) {
        return prefix + " " + IncidentUtil.oneLiner(thrown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpVmMetrics(String incidentId) {
        try (PrintWriter writer = null;){
            File dmpFileDirectory = new File(EventUtil.getDumpPathPrefix());
            dmpFileDirectory.mkdirs();
            String dumpFile = EventUtil.getDumpPathPrefix() + "/" + INC_DUMP_FILE_NAME + incidentId + INC_DUMP_FILE_EXT;
            GZIPOutputStream outStream = new GZIPOutputStream(new FileOutputStream(dumpFile));
            writer = new PrintWriter(outStream, true);
            VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();
            writer.print("\n\n\n---------------------------  METRICS ---------------------------\n\n");
            writer.flush();
            JsonFactory jf = new JsonFactory();
            jf.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            ObjectMapper mapper = new ObjectMapper(jf);
            mapper.setDateFormat(new StdDateFormat());
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            MetricsServlet metrics = new MetricsServlet(Clock.defaultClock(), vm, Metrics.defaultRegistry(), jf, true);
            JsonGenerator json = jf.createGenerator(outStream, JsonEncoding.UTF8);
            json.useDefaultPrettyPrinter();
            json.writeStartObject();
            IncidentUtil.writeVmMetrics(json, vm);
            metrics.writeRegularMetrics(json, null, false);
            json.writeEndObject();
            json.close();
            logger.debug("Creating full thread dump in dump file {}", dumpFile);
            writer.print("\n\n\n---------------------------  THREAD DUMP ---------------------------\n\n");
            writer.flush();
            vm.threadDump(outStream);
            logger.debug("Dump file {} is created.", dumpFile);
        }
    }

    private static void writeVmMetrics(JsonGenerator json, VirtualMachineMetrics vm) throws IOException {
        json.writeFieldName("jvm");
        json.writeStartObject();
        json.writeFieldName("vm");
        json.writeStartObject();
        json.writeStringField("name", vm.name());
        json.writeStringField("version", vm.version());
        json.writeEndObject();
        json.writeFieldName("memory");
        json.writeStartObject();
        json.writeNumberField("totalInit", vm.totalInit());
        json.writeNumberField("totalUsed", vm.totalUsed());
        json.writeNumberField("totalMax", vm.totalMax());
        json.writeNumberField("totalCommitted", vm.totalCommitted());
        json.writeNumberField("heapInit", vm.heapInit());
        json.writeNumberField("heapUsed", vm.heapUsed());
        json.writeNumberField("heapMax", vm.heapMax());
        json.writeNumberField("heapCommitted", vm.heapCommitted());
        json.writeNumberField("heap_usage", vm.heapUsage());
        json.writeNumberField("non_heap_usage", vm.nonHeapUsage());
        json.writeFieldName("memory_pool_usages");
        json.writeStartObject();
        for (Map.Entry<String, Double> pool : vm.memoryPoolUsage().entrySet()) {
            json.writeNumberField(pool.getKey(), pool.getValue());
        }
        json.writeEndObject();
        json.writeEndObject();
        Map<String, VirtualMachineMetrics.BufferPoolStats> bufferPoolStats = vm.getBufferPoolStats();
        if (!bufferPoolStats.isEmpty()) {
            json.writeFieldName("buffers");
            json.writeStartObject();
            json.writeFieldName("direct");
            json.writeStartObject();
            json.writeNumberField("count", bufferPoolStats.get("direct").getCount());
            json.writeNumberField("memoryUsed", bufferPoolStats.get("direct").getMemoryUsed());
            json.writeNumberField("totalCapacity", bufferPoolStats.get("direct").getTotalCapacity());
            json.writeEndObject();
            json.writeFieldName("mapped");
            json.writeStartObject();
            json.writeNumberField("count", bufferPoolStats.get("mapped").getCount());
            json.writeNumberField("memoryUsed", bufferPoolStats.get("mapped").getMemoryUsed());
            json.writeNumberField("totalCapacity", bufferPoolStats.get("mapped").getTotalCapacity());
            json.writeEndObject();
            json.writeEndObject();
        }
        json.writeNumberField("daemon_thread_count", vm.daemonThreadCount());
        json.writeNumberField("thread_count", vm.threadCount());
        json.writeNumberField("current_time", Clock.defaultClock().time());
        json.writeNumberField("uptime", vm.uptime());
        try {
            json.writeNumberField("fd_usage", vm.fileDescriptorUsage());
        }
        catch (Exception e) {
            logger.info("Error writing fd_usage", e);
        }
        json.writeFieldName("thread-states");
        json.writeStartObject();
        for (Map.Entry<Thread.State, Double> entry : vm.threadStatePercentages().entrySet()) {
            json.writeNumberField(entry.getKey().toString().toLowerCase(), entry.getValue());
        }
        json.writeEndObject();
        json.writeFieldName("garbage-collectors");
        json.writeStartObject();
        for (Map.Entry<Object, Object> entry : vm.garbageCollectors().entrySet()) {
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            VirtualMachineMetrics.GarbageCollectorStats gc = (VirtualMachineMetrics.GarbageCollectorStats)entry.getValue();
            json.writeNumberField("runs", gc.getRuns());
            json.writeNumberField("time", gc.getTime(TimeUnit.MILLISECONDS));
            json.writeEndObject();
        }
        json.writeEndObject();
        json.writeEndObject();
    }
}

