/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.iterable;

import java.util.Iterator;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ListObjectsRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectListing;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3ObjectSummary;

public class S3Objects
implements Iterable<S3ObjectSummary> {
    private AmazonS3 s3;
    private String prefix = null;
    private String bucketName;
    private Integer batchSize = null;

    private S3Objects(AmazonS3 s3, String bucketName) {
        this.s3 = s3;
        this.bucketName = bucketName;
    }

    public static S3Objects inBucket(AmazonS3 s3, String bucketName) {
        return new S3Objects(s3, bucketName);
    }

    public static S3Objects withPrefix(AmazonS3 s3, String bucketName, String prefix) {
        S3Objects objects = new S3Objects(s3, bucketName);
        objects.prefix = prefix;
        return objects;
    }

    public S3Objects withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public AmazonS3 getS3() {
        return this.s3;
    }

    @Override
    public Iterator<S3ObjectSummary> iterator() {
        return new S3ObjectIterator();
    }

    private class S3ObjectIterator
    implements Iterator<S3ObjectSummary> {
        private ObjectListing currentListing = null;
        private Iterator<S3ObjectSummary> currentIterator = null;

        private S3ObjectIterator() {
        }

        @Override
        public boolean hasNext() {
            this.prepareCurrentListing();
            return this.currentIterator.hasNext();
        }

        @Override
        public S3ObjectSummary next() {
            this.prepareCurrentListing();
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void prepareCurrentListing() {
            while (this.currentListing == null || !this.currentIterator.hasNext() && this.currentListing.isTruncated()) {
                if (this.currentListing == null) {
                    ListObjectsRequest req = new ListObjectsRequest();
                    req.setBucketName(S3Objects.this.getBucketName());
                    req.setPrefix(S3Objects.this.getPrefix());
                    req.setMaxKeys(S3Objects.this.getBatchSize());
                    this.currentListing = S3Objects.this.getS3().listObjects(req);
                } else {
                    this.currentListing = S3Objects.this.getS3().listNextBatchOfObjects(this.currentListing);
                }
                this.currentIterator = this.currentListing.getObjectSummaries().iterator();
            }
        }
    }
}

