/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class RestRequest {
    static final SFLogger logger = SFLoggerFactory.getLogger(RestRequest.class);
    private static long minBackoffInMilli = 1000L;
    private static long maxBackoffInMilli = 16000L;
    private static int MIN_RETRY_COUNT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters) throws IOException, SnowflakeSQLException {
        long startTime;
        CloseableHttpResponse response = null;
        long startTimePerRequest = startTime = System.currentTimeMillis();
        long elapsedMilliForTransientIssues = 0L;
        long backoffInMilli = minBackoffInMilli;
        long elapsedMilliForLastCall = 0L;
        int retryCount = 0;
        int origSocketTimeout = 0;
        Exception savedEx = null;
        while (true) {
            logger.debug("Retry count: {}", retryCount);
            try {
                startTimePerRequest = System.currentTimeMillis();
                if (withoutCookies) {
                    httpRequest.setConfig(HttpUtil.getRequestConfigWithoutcookies());
                }
                if (injectSocketTimeout != 0 && retryCount == 0) {
                    logger.info("Injecting socket timeout by setting socket timeout to {} millisecond ", injectSocketTimeout);
                    httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(injectSocketTimeout, withoutCookies));
                }
                if (retryCount > 0) {
                    URIBuilder builder = new URIBuilder(httpRequest.getURI());
                    builder.setParameter("retryCount", String.valueOf(retryCount));
                    if (includeRetryParameters) {
                        builder.setParameter("clientStartTime", String.valueOf(startTime));
                    }
                    httpRequest.setURI(builder.build());
                }
                response = httpClient.execute(httpRequest);
            }
            catch (Exception ex) {
                if (ex instanceof IllegalStateException) {
                    throw new SnowflakeSQLException(ex, ErrorCode.INVALID_STATE.getSqlState(), (int)ErrorCode.INVALID_STATE.getMessageCode(), ex.getMessage());
                }
                savedEx = ex;
                if (System.currentTimeMillis() - startTimePerRequest > 300000L) {
                    logger.error("HTTP request took longer than 5 min: {} sec", (System.currentTimeMillis() - startTimePerRequest) / 1000L);
                }
                logger.warn("Exception encountered for: " + httpRequest.toString(), ex);
            }
            finally {
                if (injectSocketTimeout != 0 && retryCount == 0) {
                    httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(origSocketTimeout, withoutCookies));
                }
            }
            if (response != null && (response.getStatusLine().getStatusCode() < 500 || response.getStatusLine().getStatusCode() >= 600) && response.getStatusLine().getStatusCode() != 408 && response.getStatusLine().getStatusCode() != 403) {
                logger.debug("HTTP response code: {}", response.getStatusLine().getStatusCode());
                if (response.getStatusLine().getStatusCode() == 200) break;
                logger.debug("Got error response which is not retriable, http status={}, request={}", response.getStatusLine().getStatusCode(), httpRequest);
                EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, "StatusCode: " + response.getStatusLine().getStatusCode() + ", Reason: " + response.getStatusLine().getReasonPhrase() + ", Request: " + httpRequest.toString(), false);
                break;
            }
            if (response != null) {
                logger.warn("HTTP response not ok: status code={}, request={}", response.getStatusLine().getStatusCode(), httpRequest);
            } else {
                logger.warn("Null response for request={}", httpRequest);
            }
            elapsedMilliForLastCall = System.currentTimeMillis() - startTimePerRequest;
            if (canceling != null && canceling.get()) {
                logger.info("Stop retrying since canceling is requested");
                break;
            }
            if (retryTimeout > 0L && (elapsedMilliForTransientIssues += elapsedMilliForLastCall) / 1000L > retryTimeout && retryCount >= MIN_RETRY_COUNT) {
                logger.error("Stop retrying since elapsed time due to network issues has reached timeout. Elapsed=" + elapsedMilliForTransientIssues + " milliseconds, timeout=" + retryTimeout + " seconds");
                if (response != null || savedEx == null) break;
                throw new SnowflakeSQLException("58030", ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered for HTTP request: " + savedEx.getMessage());
            }
            logger.debug("Retrying request: {}", httpRequest);
            if (backoffInMilli > elapsedMilliForLastCall) {
                try {
                    Thread.sleep(backoffInMilli - elapsedMilliForLastCall);
                    elapsedMilliForTransientIssues += backoffInMilli - elapsedMilliForLastCall;
                }
                catch (InterruptedException ex1) {
                    logger.debug("Backoff sleep before retrying login got interrupted");
                }
            }
            if (backoffInMilli < maxBackoffInMilli) {
                backoffInMilli *= 2L;
            }
            httpRequest.releaseConnection();
            ++retryCount;
        }
        if (response == null) {
            logger.error("Returning null response for request: {}", httpRequest);
        } else if (response.getStatusLine().getStatusCode() != 200) {
            logger.error("Got error response: http status={}, request={}", response.getStatusLine().getStatusCode(), httpRequest);
        }
        return response;
    }
}

