/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeClob;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeConnectionV1
implements Connection {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeConnectionV1.class);
    private static final String JDBC_PROTOCOL_PREFIX = "jdbc:snowflake";
    private static final String NATIVE_PROTOCOL = "http";
    private static final String SSL_NATIVE_PROTOCOL = "https";
    private boolean isClosed;
    private SQLWarning sqlWarnings = null;
    private AtomicInteger _injectedDelay = new AtomicInteger(0);
    private String databaseVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private int networkTimeoutInMilli = 0;
    private Properties clientInfo = new Properties();
    private int transactionIsolation = 0;
    private SFSession sfSession;

    public SnowflakeConnectionV1(String url, Properties info) throws SQLException {
        logger.debug("Trying to establish session, JDBC driver version: {}", SnowflakeDriver.implementVersion);
        TelemetryService.getInstance().updateContext(url, info);
        this.sfSession = new SFSession();
        try {
            this.initSessionProperties(url, info);
            this.sfSession.open();
            this.databaseVersion = this.sfSession.getDatabaseVersion();
            this.databaseMajorVersion = this.sfSession.getDatabaseMajorVersion();
            this.databaseMinorVersion = this.sfSession.getDatabaseMinorVersion();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        this.appendWarnings(this.sfSession.getSqlWarnings());
        this.isClosed = false;
    }

    private void raiseSQLExceptionIfConnectionIsClosed() throws SQLException {
        if (this.isClosed) {
            throw new SnowflakeSQLException(ErrorCode.CONNECTION_CLOSED, new Object[0]);
        }
    }

    static Map<String, Object> mergeProperties(String url, Properties info) {
        String queryParams;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int queryParamsIndex = url.indexOf("?");
        String serverUrl = queryParamsIndex > 0 ? url.substring(0, queryParamsIndex) : url;
        String string = queryParams = queryParamsIndex > 0 ? url.substring(queryParamsIndex + 1) : null;
        if (queryParams != null && !queryParams.isEmpty()) {
            String[] entries;
            for (String entry : entries = queryParams.split("&")) {
                int sep = entry.indexOf("=");
                if (sep <= 0) continue;
                String key = entry.substring(0, sep).toUpperCase();
                properties.put(key, entry.substring(sep + 1));
            }
        }
        for (Map.Entry entry : info.entrySet()) {
            properties.put(entry.getKey().toString().toUpperCase(), entry.getValue());
        }
        boolean sslOn = SnowflakeConnectionV1.getBooleanTrueByDefault(properties.get("SSL"));
        serverUrl = serverUrl.replace(JDBC_PROTOCOL_PREFIX, sslOn ? SSL_NATIVE_PROTOCOL : NATIVE_PROTOCOL);
        properties.put("SERVERURL", serverUrl);
        properties.remove("SSL");
        if (properties.get("ACCOUNT") == null && serverUrl.indexOf(".") > 0 && serverUrl.indexOf("://") > 0) {
            String string2 = serverUrl.substring(serverUrl.indexOf("://") + 3, serverUrl.indexOf("."));
            logger.debug("set account name to {}", string2);
            properties.put("ACCOUNT", string2);
        }
        return properties;
    }

    private void initSessionProperties(String url, Properties info) throws SFException {
        Map<String, Object> properties = SnowflakeConnectionV1.mergeProperties(url, info);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.sfSession.addProperty(entry.getKey(), entry.getValue());
        }
        this.sfSession.addProperty(SFSessionProperty.APP_ID, (Object)"JDBC");
        this.sfSession.addProperty(SFSessionProperty.APP_VERSION, (Object)SnowflakeDriver.implementVersion);
        for (Map.Entry<String, Object> entry : SessionUtil.JVM_PARAMS_TO_PARAMS.entrySet()) {
            String value = System.getProperty(entry.getKey());
            if (value == null || this.sfSession.containProperty((String)entry.getValue())) continue;
            this.sfSession.addProperty((String)entry.getValue(), (Object)value);
        }
    }

    private static boolean getBooleanTrueByDefault(Object value) {
        if (value instanceof String) {
            String value0 = (String)value;
            return !"off".equalsIgnoreCase(value0) && !"false".equalsIgnoreCase(value0);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    private void executeImmediate(String stmtText) throws SQLException {
        try (Statement statement = this.createStatement();){
            statement.execute(stmtText);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.createStatement(1003, 1007);
    }

    @Override
    public void close() throws SQLException {
        logger.debug(" public void close()");
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (this.sfSession != null) {
                this.sfSession.close();
                this.sfSession = null;
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug(" public boolean isClosed()");
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        logger.debug(" public DatabaseMetaData getMetaData()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return new SnowflakeDatabaseMetaData(this);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        logger.debug(" public CallableStatement prepareCall(String sql)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug(" public CallableStatement prepareCall(String sql, int resultSetType,int resultSetConcurrency");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug(" public CallableStatement prepareCall(String sql, int resultSetType,");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        logger.debug("public String nativeSQL(String sql)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        logger.debug("void setAutoCommit(boolean isAutoCommit)");
        this.executeImmediate("alter session /* JDBC:SnowflakeConnectionV1.setAutoCommit*/ set autocommit=" + isAutoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        logger.debug("boolean getAutoCommit()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        logger.debug("void commit()");
        this.executeImmediate("commit");
    }

    @Override
    public void rollback() throws SQLException {
        logger.debug("void rollback()");
        this.executeImmediate("rollback");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        logger.debug("void rollback(Savepoint savepoint)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        logger.debug("void setReadOnly(boolean readOnly)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        if (readOnly) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.debug("boolean isReadOnly()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        logger.debug("void setCatalog(String catalog)");
        this.executeImmediate("use database \"" + catalog + "\"");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        logger.debug("void setTransactionIsolation(int level), level = {}", level);
        this.raiseSQLExceptionIfConnectionIsClosed();
        if (level != 0 && level != 2) {
            throw new SQLFeatureNotSupportedException("Transaction Isolation " + level + " not supported.", ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        this.transactionIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        logger.debug("int getTransactionIsolation()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.transactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("SQLWarning getWarnings()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sqlWarnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("void clearWarnings()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.sfSession.clearSqlWarnings();
        this.sqlWarnings = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug("Statement createStatement(int resultSetType, int resultSetConcurrency)");
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug("Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability");
        return new SnowflakeStatementV1(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.debug("PreparedStatement prepareStatement(String sql)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.prepareStatement(sql, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("PreparedStatement prepareStatement(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        logger.debug("PreparedStatement prepareStatement(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug("PreparedStatement prepareStatement(String sql, int resultSetType,");
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug("PreparedStatement prepareStatement(String sql, int resultSetType,");
        return new SnowflakePreparedStatementV1(this, sql, false, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, boolean skipParsing) throws SQLException {
        logger.debug("PreparedStatement prepareStatement(String sql, boolean skipParsing)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return new SnowflakePreparedStatementV1(this, sql, skipParsing, 1003, 1007, 2);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return new SnowflakeClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout is less than 0");
        }
        return !this.isClosed;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        logger.debug("void setClientInfo(Properties properties)");
        if (this.isClosed) {
            throw new SQLClientInfoException();
        }
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
        this.sfSession.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        logger.debug("void setClientInfo(String name, String value)");
        if (this.isClosed) {
            throw new SQLClientInfoException();
        }
        this.clientInfo.setProperty(name, value);
        this.sfSession.setClientInfo(name, value);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        logger.debug("Properties getClientInfo()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        logger.debug("String getClientInfo(String name)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getClientInfo(name);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        logger.debug("Array createArrayOf(String typeName, Object[] elements)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        logger.debug("Struct createStruct(String typeName, Object[] attributes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        logger.debug("void setSchema(String schema)");
        String databaseName = this.getCatalog();
        if (databaseName == null) {
            this.executeImmediate("use schema \"" + schema + "\"");
        } else {
            this.executeImmediate("use schema \"" + databaseName + "\".\"" + schema + "\"");
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        logger.debug("void abort(Executor executor)");
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        logger.debug("void setNetworkTimeout(Executor executor, int milliseconds)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.networkTimeoutInMilli = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        logger.debug("int getNetworkTimeout()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.networkTimeoutInMilli;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("<T> T unwrap(Class<T> iface)");
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    String getDatabaseVersion() {
        return this.databaseVersion;
    }

    @Deprecated
    public void uploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName, long streamSize) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, false);
    }

    public void uploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName, boolean compressData) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, compressData);
    }

    @Deprecated
    public void compressAndUploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, true);
    }

    private void uploadStreamInternal(String stageName, String destPrefix, InputStream inputStream, String destFileName, boolean compressData) throws SQLException {
        logger.debug("upload data from stream: stageName={}, destPrefix={}, destFileName={}", stageName, destPrefix, destFileName);
        if (stageName == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null");
        }
        if (destFileName == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null");
        }
        SnowflakeStatementV1 stmt = this.createStatement().unwrap(SnowflakeStatementV1.class);
        StringBuilder putCommand = new StringBuilder();
        putCommand.append("put file:///tmp/placeholder ");
        if (!stageName.startsWith("@")) {
            putCommand.append("@");
        }
        putCommand.append(stageName);
        if (destPrefix != null) {
            if (!destPrefix.startsWith("/")) {
                putCommand.append("/");
            }
            putCommand.append(destPrefix);
        }
        putCommand.append(" overwrite=true");
        SnowflakeFileTransferAgent transferAgent = null;
        transferAgent = new SnowflakeFileTransferAgent(putCommand.toString(), this.sfSession, stmt.getSfStatement());
        transferAgent.setSourceStream(inputStream);
        transferAgent.setDestFileNameForStreamSource(destFileName);
        transferAgent.setCompressSourceFromStream(compressData);
        transferAgent.execute();
        stmt.close();
    }

    public InputStream downloadStream(String stageName, String sourceFileName, boolean decompress) throws SQLException {
        logger.debug("download data to stream: stageName={}, sourceFileName={}", stageName, sourceFileName);
        if (Strings.isNullOrEmpty(stageName)) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null or empty");
        }
        if (Strings.isNullOrEmpty(sourceFileName)) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "source file name is null or empty");
        }
        SnowflakeStatementV1 stmt = new SnowflakeStatementV1(this, 1003, 1007, 2);
        StringBuilder getCommand = new StringBuilder();
        getCommand.append("get ");
        if (!stageName.startsWith("@")) {
            getCommand.append("@");
        }
        getCommand.append(stageName);
        getCommand.append("/");
        if (sourceFileName.startsWith("/")) {
            sourceFileName = sourceFileName.substring(1);
        }
        getCommand.append(sourceFileName);
        getCommand.append(" file:///tmp/ /*jdbc download stream*/");
        SnowflakeFileTransferAgent transferAgent = new SnowflakeFileTransferAgent(getCommand.toString(), this.sfSession, stmt.getSfStatement());
        InputStream stream = transferAgent.downloadStream(sourceFileName);
        if (decompress) {
            try {
                return new GZIPInputStream(stream);
            }
            catch (IOException ex) {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), ex.getMessage());
            }
        }
        return stream;
    }

    public void setInjectedDelay(int delay) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.sfSession.setInjectedDelay(delay);
    }

    void injectedDelay() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        int d = this._injectedDelay.get();
        if (d != 0) {
            this._injectedDelay.set(0);
            try {
                logger.trace("delayed for {}", d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setInjectFileUploadFailure(String fileToFail) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.sfSession.setInjectFileUploadFailure(fileToFail);
    }

    public SFSession getSfSession() {
        return this.sfSession;
    }

    private void appendWarning(SQLWarning w) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = w;
        } else {
            this.sqlWarnings.setNextWarning(w);
        }
    }

    private void appendWarnings(List<SFException> warnings) {
        for (SFException e : warnings) {
            this.appendWarning(new SQLWarning(e.getMessage(), e.getSqlState(), e.getVendorCode()));
        }
    }
}

