/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.GetObjectMetadataRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.HeadBucketRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.HeadBucketResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.waiters.HeadBucketFunction;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.waiters.HeadObjectFunction;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.FixedDelayStrategy;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.HttpFailureStatusAcceptor;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.HttpSuccessStatusAcceptor;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.MaxAttemptsRetryStrategy;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.PollingStrategy;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.Waiter;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.WaiterBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.WaiterState;

public class AmazonS3Waiters {
    private final AmazonS3 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonS3Waiters(AmazonS3 client) {
        this.client = client;
    }

    public Waiter bucketNotExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter bucketExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(301, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(403, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter objectExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter objectNotExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

