/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.AbstractECMultiplier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECCurve;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECLookupTable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.FixedPointPreCompInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.FixedPointUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.raw.Nat;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint);
        ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
        int n2 = fixedPointPreCompInfo.getWidth();
        int n3 = (n + n2 - 1) / n2;
        ECPoint eCPoint2 = eCCurve.getInfinity();
        int n4 = n3 * n2;
        int[] nArray = Nat.fromBigInteger(n4, bigInteger);
        int n5 = n4 - 1;
        for (int i = 0; i < n3; ++i) {
            int n6 = 0;
            for (int j = n5 - i; j >= 0; j -= n3) {
                n6 <<= 1;
                n6 |= Nat.getBit(nArray, j);
            }
            ECPoint eCPoint3 = eCLookupTable.lookup(n6);
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        return eCPoint2.add(fixedPointPreCompInfo.getOffset());
    }

    protected int getWidthForCombSize(int n) {
        return n > 257 ? 6 : 5;
    }
}

