/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFChildResult;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFFixedViewResultSet;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SFResultSetFactory;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatementMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.core.bind.BindException;
import net.snowflake.client.core.bind.BindUploader;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;

public class SFStatement {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFStatement.class);
    private SFSession session;
    private SFBaseResultSet resultSet = null;
    private HttpRequestBase httpRequest;
    private Boolean isClosed = false;
    private Integer sequenceId = -1;
    private String requestId = null;
    private String sqlText = null;
    private final AtomicBoolean canceling = new AtomicBoolean(false);
    private int queryTimeout = 0;
    private boolean isFileTransfer = false;
    private SnowflakeFileTransferAgent transferAgent = null;
    private final Map<String, Object> statementParametersMap = new HashMap<String, Object>();
    private static final int MAX_STATEMENT_PARAMETERS = 1000;
    private String describeJobUUID;
    private boolean hasUnsupportedStageBind = false;
    private List<SFChildResult> childResults = null;
    private int conservativePrefetchThreads;
    private int conservativeResultChunkSize;
    private long conservativeMemoryLimit;

    public void addProperty(String propertyName, Object propertyValue) throws SFException {
        this.statementParametersMap.put(propertyName, propertyValue);
        if ("query_timeout".equalsIgnoreCase(propertyName)) {
            this.queryTimeout = (Integer)propertyValue;
        }
        if (this.statementParametersMap.size() > 1000) {
            throw new SFException(ErrorCode.TOO_MANY_STATEMENT_PARAMETERS, 1000);
        }
    }

    public SFStatement(SFSession session) {
        logger.debug(" public SFStatement(SFSession session)");
        this.session = session;
        Integer queryTimeout = session == null ? null : session.getQueryTimeout();
        this.queryTimeout = queryTimeout != null ? queryTimeout : this.queryTimeout;
    }

    private void sanityCheckQuery(String sql) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            throw new SnowflakeSQLException("03000", ErrorCode.INVALID_SQL.getMessageCode(), sql);
        }
    }

    private SFBaseResultSet executeQuery(String sql, Map<String, ParameterBindingDTO> parametersBinding, boolean describeOnly, CallingMethod caller) throws SQLException, SFException {
        this.sanityCheckQuery(sql);
        String trimmedSql = sql.trim();
        if (this.isFileTransfer(trimmedSql)) {
            logger.debug("Executing file transfer locally: {}", sql);
            return this.executeFileTransfer(sql);
        }
        return this.executeQueryInternal(sql, parametersBinding, describeOnly, describeOnly, caller);
    }

    public SFStatementMetaData describe(String sql) throws SFException, SQLException {
        SFBaseResultSet baseResultSet = this.executeQuery(sql, null, true, null);
        this.describeJobUUID = baseResultSet.getQueryId();
        return new SFStatementMetaData(baseResultSet.getMetaData(), baseResultSet.getStatementType(), baseResultSet.getNumberOfBinds(), baseResultSet.isArrayBindSupported(), baseResultSet.getMetaDataOfBinds());
    }

    SFBaseResultSet executeQueryInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings, boolean describeOnly, boolean internal, CallingMethod caller) throws SQLException, SFException {
        this.resetState();
        logger.debug("executeQuery: {}", () -> SecretDetector.maskSecrets(sql));
        if (this.session == null || this.session.isClosed()) {
            throw new SQLException("connection is closed");
        }
        Object result = this.executeHelper(sql, "application/snowflake", parameterBindings, describeOnly, internal);
        if (result == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "got null result");
        }
        Object sortProperty = this.session.getSFSessionProperty("sort");
        boolean sortResult = sortProperty != null && (Boolean)sortProperty != false;
        logger.debug("Creating result set");
        try {
            JsonNode jsonResult = (JsonNode)result;
            this.resultSet = SFResultSetFactory.getResultSet(jsonResult, this, sortResult);
            this.childResults = ResultUtil.getChildResults(this.session, this.requestId, jsonResult);
            if (!this.childResults.isEmpty()) {
                SFStatementType type = this.childResults.get((int)0).type;
                if (caller == CallingMethod.EXECUTE_QUERY && !type.isGenerateResultSet()) {
                    throw new SnowflakeSQLException(ErrorCode.QUERY_FIRST_RESULT_NOT_RESULT_SET, new Object[0]);
                }
                if (caller == CallingMethod.EXECUTE_UPDATE && type.isGenerateResultSet()) {
                    throw new SnowflakeSQLException(ErrorCode.UPDATE_FIRST_RESULT_NOT_UPDATE_COUNT, new Object[0]);
                }
                this.getMoreResults();
            }
        }
        catch (OutOfMemoryError | SnowflakeSQLException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            logger.error("Exception creating result", ex);
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, IncidentUtil.oneLiner("exception creating result", ex)), null, null);
        }
        logger.debug("Done creating result set");
        return this.resultSet;
    }

    private void setTimeBomb(ScheduledExecutorService executor) {
        class TimeBombTask
        implements Callable<Void> {
            private final SFStatement statement;

            TimeBombTask(SFStatement statement) {
                this.statement = statement;
            }

            @Override
            public Void call() throws SQLException {
                try {
                    this.statement.cancel();
                }
                catch (SFException ex) {
                    throw new SnowflakeSQLException(ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
                }
                return null;
            }
        }
        executor.schedule(new TimeBombTask(this), (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeHelper(String sql, String mediaType, Map<String, ParameterBindingDTO> bindValues, boolean describeOnly, boolean internal) throws SnowflakeSQLException, SFException {
        ExecutorService executor = null;
        try {
            SFStatement sFStatement = this;
            synchronized (sFStatement) {
                if (this.isClosed.booleanValue()) {
                    throw new SFException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
                }
                if (this.canceling.get()) {
                    throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
                }
                if (this.requestId != null) {
                    throw new SnowflakeSQLException("0A000", ErrorCode.STATEMENT_ALREADY_RUNNING_QUERY.getMessageCode());
                }
                this.requestId = UUID.randomUUID().toString();
                this.sequenceId = this.session.getAndIncrementSequenceId();
                this.sqlText = sql;
            }
            EventUtil.triggerStateTransition(BasicEvent.QueryState.QUERY_STARTED, String.format(BasicEvent.QueryState.QUERY_STARTED.getArgString(), this.requestId));
            int numBinds = BindUploader.arrayBindValueCount(bindValues);
            String bindStagePath = null;
            if (0 < this.session.getArrayBindStageThreshold() && this.session.getArrayBindStageThreshold() <= numBinds && !describeOnly && !this.hasUnsupportedStageBind && BindUploader.isArrayBind(bindValues)) {
                try (BindUploader uploader = BindUploader.newInstance(this.session, this.requestId);){
                    uploader.upload(bindValues);
                    bindStagePath = uploader.getStagePath();
                }
                catch (BindException ex) {
                    logger.debug("Exception encountered trying to upload binds to stage. Attaching binds in payload instead. ", ex);
                    TelemetryData errorLog = TelemetryUtil.buildJobData(this.requestId, ex.type.field, 1L);
                    this.session.getTelemetryClient().tryAddLogToBatch(errorLog);
                    IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.NON_FATAL_ERROR, IncidentUtil.oneLiner("Failed to upload binds to stage:", ex)), null, this.requestId);
                }
            }
            if (this.session.isConservativeMemoryUsageEnabled()) {
                logger.debug("JDBC conservative memory usage is enabled.");
                this.calculateConservativeMemoryUsage();
            }
            StmtUtil.StmtInput stmtInput = new StmtUtil.StmtInput();
            stmtInput.setSql(sql).setMediaType(mediaType).setInternal(internal).setDescribeOnly(describeOnly).setServerUrl(this.session.getServerUrl()).setRequestId(this.requestId).setSequenceId(this.sequenceId).setParametersMap(this.statementParametersMap).setSessionToken(this.session.getSessionToken()).setNetworkTimeoutInMillis(this.session.getNetworkTimeoutInMilli()).setInjectSocketTimeout(this.session.getInjectSocketTimeout()).setInjectClientPause(this.session.getInjectClientPause()).setCanceling(this.canceling).setRetry(false).setDescribedJobId(this.describeJobUUID).setCombineDescribe(this.session.getEnableCombineDescribe()).setQuerySubmissionTime(System.currentTimeMillis()).setServiceName(this.session.getServiceName());
            if (bindStagePath != null) {
                stmtInput.setBindValues(null).setBindStage(bindStagePath);
                this.setUseNewSqlFormat(true);
            } else {
                stmtInput.setBindValues(bindValues).setBindStage(null);
            }
            if (this.canceling.get()) {
                logger.debug("Query cancelled");
                throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
            }
            if (this.queryTimeout > 0) {
                executor = Executors.newScheduledThreadPool(1);
                this.setTimeBomb((ScheduledExecutorService)executor);
            }
            StmtUtil.StmtOutput stmtOutput = null;
            while (true) {
                boolean sessionRenewed = false;
                try {
                    stmtOutput = StmtUtil.execute(stmtInput);
                }
                catch (SnowflakeSQLException ex) {
                    if (ex.getErrorCode() == 390112) {
                        try {
                            this.session.renewSession(stmtInput.sessionToken);
                        }
                        catch (SnowflakeReauthenticationRequest ex0) {
                            if (this.session.isExternalbrowserAuthenticator()) {
                                this.reauthenticate();
                            }
                            throw ex0;
                        }
                    } else {
                        throw ex;
                    }
                    stmtInput.setSessionToken(this.session.getSessionToken());
                    stmtInput.setRetry(true);
                    sessionRenewed = true;
                    logger.debug("Session got renewed, will retry");
                    if (sessionRenewed && !this.canceling.get()) continue;
                }
                break;
            }
            if (System.getProperty("snowflake.enable_incident_test1") != null && System.getProperty("snowflake.enable_incident_test1").equals("true")) {
                throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.STATEMENT_CLOSED, new Object[0]), null, this.requestId);
            }
            Object object = this;
            synchronized (object) {
                this.sequenceId = -1;
                this.requestId = null;
            }
            if (this.canceling.get()) {
                throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
            }
            logger.debug("Returning from executeHelper");
            if (stmtOutput != null) {
                object = stmtOutput.getResult();
                return object;
            }
            try {
                throw new SFException(ErrorCode.INTERNAL_ERROR, new Object[0]);
            }
            catch (SFException | SnowflakeSQLException ex) {
                this.isClosed = true;
                throw ex;
            }
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            this.setUseNewSqlFormat(false);
        }
    }

    private void calculateConservativeMemoryUsage() {
        long memoryLimitInBytes;
        int clientMemoryLimit = this.session.getClientMemoryLimit();
        int clientPrefetchThread = this.session.getClientPrefetchThreads();
        int clientChunkSize = this.session.getClientResultChunkSize();
        if ((long)clientMemoryLimit == SessionUtil.DEFAULT_CLIENT_MEMORY_LIMIT) {
            long freeMemoryToUse = Runtime.getRuntime().freeMemory() * 8L / 10L;
            memoryLimitInBytes = Math.min(2L * (long)clientPrefetchThread * (long)clientChunkSize * 1024L * 1024L, freeMemoryToUse);
        } else {
            memoryLimitInBytes = clientMemoryLimit * 1024 * 1024;
        }
        this.conservativeMemoryLimit = memoryLimitInBytes;
        this.reducePrefetchThreadsAndChunkSizeToFitMemoryLimit(this.conservativeMemoryLimit, clientPrefetchThread, clientChunkSize);
    }

    private void updateConservativeResultChunkSize(int clientChunkSize) {
        if (clientChunkSize != this.conservativeResultChunkSize) {
            logger.debug("conservativeResultChunkSize changed from {} to {}", this.conservativeResultChunkSize, clientChunkSize);
            this.conservativeResultChunkSize = clientChunkSize;
            this.statementParametersMap.put("CLIENT_RESULT_CHUNK_SIZE", this.conservativeResultChunkSize);
        }
    }

    private void reducePrefetchThreadsAndChunkSizeToFitMemoryLimit(long clientMemoryLimit, int clientPrefetchThread, int clientChunkSize) {
        if (clientPrefetchThread != SessionUtil.DEFAULT_CLIENT_PREFETCH_THREADS) {
            this.conservativePrefetchThreads = clientPrefetchThread;
            while (clientChunkSize >= SessionUtil.MIN_CLIENT_CHUNK_SIZE) {
                if (clientMemoryLimit >= 2L * (long)clientPrefetchThread * (long)clientChunkSize * 1024L * 1024L) {
                    this.updateConservativeResultChunkSize(clientChunkSize);
                    return;
                }
                clientChunkSize -= 16;
            }
            this.updateConservativeResultChunkSize(SessionUtil.MIN_CLIENT_CHUNK_SIZE);
        } else {
            while (clientPrefetchThread > 1) {
                for (clientChunkSize = SessionUtil.MAX_CLIENT_CHUNK_SIZE; clientChunkSize >= SessionUtil.MIN_CLIENT_CHUNK_SIZE; clientChunkSize -= 16) {
                    if (clientMemoryLimit < 2L * (long)clientPrefetchThread * (long)clientChunkSize * 1024L * 1024L) continue;
                    this.conservativePrefetchThreads = clientPrefetchThread;
                    this.updateConservativeResultChunkSize(clientChunkSize);
                    return;
                }
                --clientPrefetchThread;
            }
            this.conservativePrefetchThreads = clientPrefetchThread;
            this.updateConservativeResultChunkSize(SessionUtil.MIN_CLIENT_CHUNK_SIZE);
        }
    }

    public int getConservativePrefetchThreads() {
        return this.conservativePrefetchThreads;
    }

    public long getConservativeMemoryLimit() {
        return this.conservativeMemoryLimit;
    }

    private void reauthenticate() throws SFException, SnowflakeSQLException {
        SFLoginInput input = new SFLoginInput();
        SFLoginOutput output = new SFLoginOutput();
        output.setSessionToken(this.session.getSessionToken());
        input.setRole(this.session.getRole());
        input.setWarehouse(this.session.getWarehouse());
        input.setDatabaseName(this.session.getDatabase());
        input.setSchemaName(this.session.getSchema());
        this.session.open();
        this.session.setCurrentObjects(input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelHelper(String sql, String mediaType) throws SnowflakeSQLException, SFException {
        SFStatement sFStatement = this;
        synchronized (sFStatement) {
            if (this.isClosed.booleanValue()) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "statement already closed");
            }
        }
        StmtUtil.StmtInput stmtInput = new StmtUtil.StmtInput();
        stmtInput.setServerUrl(this.session.getServerUrl()).setSql(sql).setMediaType(mediaType).setRequestId(this.requestId).setSessionToken(this.session.getSessionToken()).setServiceName(this.session.getServiceName());
        StmtUtil.cancel(stmtInput);
        SFStatement sFStatement2 = this;
        synchronized (sFStatement2) {
            this.sequenceId = -1;
            this.requestId = null;
        }
    }

    private boolean isFileTransfer(String sql) {
        SFStatementType statementType = StmtUtil.checkStageManageCommand(sql);
        return statementType == SFStatementType.PUT || statementType == SFStatementType.GET;
    }

    public SFBaseResultSet execute(String sql, Map<String, ParameterBindingDTO> parametersBinding, CallingMethod caller) throws SQLException, SFException {
        this.sanityCheckQuery(sql);
        this.session.injectedDelay();
        logger.debug("execute: {}", () -> SecretDetector.maskSecrets(sql));
        String trimmedSql = sql.trim();
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.executeSetProperty(sql);
            return null;
        }
        return this.executeQuery(sql, parametersBinding, false, caller);
    }

    private SFBaseResultSet executeFileTransfer(String sql) throws SQLException, SFException {
        this.session.injectedDelay();
        this.resetState();
        logger.debug("Entering executeFileTransfer");
        this.isFileTransfer = true;
        this.transferAgent = new SnowflakeFileTransferAgent(sql, this.session, this);
        try {
            this.transferAgent.execute();
            logger.debug("setting result set");
            this.resultSet = (SFFixedViewResultSet)this.transferAgent.getResultSet();
            this.childResults = Collections.emptyList();
            logger.debug("Number of cols: {}", this.resultSet.getMetaData().getColumnCount());
            logger.debug("Completed transferring data");
            return this.resultSet;
        }
        catch (SQLException ex) {
            logger.debug("Exception: {}", ex.getMessage());
            throw ex;
        }
    }

    public void close() {
        logger.debug("public void close()");
        if (this.requestId != null) {
            EventUtil.triggerStateTransition(BasicEvent.QueryState.QUERY_ENDED, String.format(BasicEvent.QueryState.QUERY_ENDED.getArgString(), this.requestId));
        }
        this.resultSet = null;
        this.childResults = null;
        this.isClosed = true;
        if (this.httpRequest != null) {
            logger.debug("releasing connection for the http request");
            this.httpRequest.releaseConnection();
            this.httpRequest = null;
        }
        try {
            this.session.getTelemetryClient().sendBatch();
        }
        catch (IOException ex) {
            logger.debug("Telemetry client failed to send batch metrics.");
        }
        this.isFileTransfer = false;
        this.transferAgent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SFException, SQLException {
        logger.debug("public void cancel()");
        if (this.canceling.get()) {
            logger.debug("Query is already cancelled");
            return;
        }
        this.canceling.set(true);
        if (this.isFileTransfer) {
            if (this.transferAgent != null) {
                logger.debug("Cancel file transferring ... ");
                this.transferAgent.cancel();
            }
        } else {
            SFStatement sFStatement = this;
            synchronized (sFStatement) {
                if (this.requestId == null) {
                    logger.debug("No remote query outstanding");
                    return;
                }
            }
            this.cancelHelper(this.sqlText, "application/snowflake");
        }
    }

    private void resetState() {
        this.resultSet = null;
        this.childResults = null;
        if (this.httpRequest != null) {
            this.httpRequest.releaseConnection();
            this.httpRequest = null;
        }
        this.isClosed = false;
        this.sequenceId = -1;
        this.requestId = null;
        this.sqlText = null;
        this.canceling.set(false);
        this.isFileTransfer = false;
        this.transferAgent = null;
    }

    public void executeSetProperty(String sql) {
        logger.debug("setting property");
        String[] tokens = sql.split("\\s+");
        if (tokens.length < 2) {
            return;
        }
        if ("sort".equalsIgnoreCase(tokens[1])) {
            if (tokens.length >= 3 && "on".equalsIgnoreCase(tokens[2])) {
                logger.debug("setting sort on");
                this.session.setSFSessionProperty("sort", true);
            } else {
                logger.debug("setting sort off");
                this.session.setSFSessionProperty("sort", false);
            }
        }
    }

    protected SFSession getSession() {
        return this.session;
    }

    public void setHasUnsupportedStageBind(boolean hasUnsupportedStageBind) {
        this.hasUnsupportedStageBind = hasUnsupportedStageBind;
    }

    private void setUseNewSqlFormat(boolean useNewSqlFormat) throws SFException {
        this.addProperty("NEW_SQL_FORMAT", useNewSqlFormat);
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (this.resultSet != null && (current == 1 || current == 3)) {
            this.resultSet.close();
        }
        this.resultSet = null;
        if (this.childResults == null || this.childResults.isEmpty()) {
            return false;
        }
        SFChildResult nextResult = this.childResults.remove(0);
        try {
            JsonNode result = StmtUtil.getQueryResultJSON(nextResult.getId(), this.session);
            Object sortProperty = this.session.getSFSessionProperty("sort");
            boolean sortResult = sortProperty != null && (Boolean)sortProperty != false;
            this.resultSet = SFResultSetFactory.getResultSet(result, this, sortResult);
            this.resultSet.setStatementType(nextResult.getType());
            return nextResult.getType().isGenerateResultSet();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex);
        }
    }

    public SFBaseResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean hasChildren() {
        return !this.childResults.isEmpty();
    }

    public static enum CallingMethod {
        EXECUTE,
        EXECUTE_UPDATE,
        EXECUTE_QUERY;

    }
}

