/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferBacked;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorDefinitionSetter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public abstract class BaseFixedWidthVector
extends BaseValueVector
implements FixedWidthVector,
FieldVector,
VectorDefinitionSetter {
    private final int typeWidth;
    protected int lastValueCapacity;
    protected final Field field;
    private int allocationMonitor;
    protected ArrowBuf validityBuffer;
    protected ArrowBuf valueBuffer;
    protected int valueCount;

    public BaseFixedWidthVector(String name, BufferAllocator allocator, FieldType fieldType, int typeWidth) {
        super(name, allocator);
        this.typeWidth = typeWidth;
        this.field = new Field(name, fieldType, null);
        this.valueCount = 0;
        this.allocationMonitor = 0;
        this.validityBuffer = allocator.getEmpty();
        this.valueBuffer = allocator.getEmpty();
        this.lastValueCapacity = 3970;
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        return this.valueBuffer.memoryAddress();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException("not supported for fixed-width vectors");
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        return this.valueBuffer;
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException("not supported for fixed-width vectors");
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        this.computeAndCheckBufferSize(valueCount);
        this.lastValueCapacity = valueCount;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.getValueBufferValueCapacity(), this.getValidityBufferValueCapacity());
    }

    private int getValueBufferValueCapacity() {
        return (int)((double)this.valueBuffer.capacity() * 1.0 / (double)this.typeWidth);
    }

    private int getValidityBufferValueCapacity() {
        return (int)((long)this.validityBuffer.capacity() * 8L);
    }

    @Override
    public void zeroVector() {
        this.initValidityBuffer();
        this.initValueBuffer();
    }

    private void initValidityBuffer() {
        this.validityBuffer.setZero(0, this.validityBuffer.capacity());
    }

    private void initValueBuffer() {
        this.valueBuffer.setZero(0, this.valueBuffer.capacity());
    }

    @Override
    public void reset() {
        this.valueCount = 0;
        this.zeroVector();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.valueBuffer = this.releaseBuffer(this.valueBuffer);
    }

    protected void incrementAllocationMonitor() {
        if (this.allocationMonitor < 0) {
            this.allocationMonitor = 0;
        }
        ++this.allocationMonitor;
    }

    protected void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.computeAndCheckBufferSize(this.lastValueCapacity);
        this.clear();
        try {
            this.allocateBytes(this.lastValueCapacity);
        }
        catch (Exception e) {
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.computeAndCheckBufferSize(valueCount);
        this.clear();
        try {
            this.allocateBytes(valueCount);
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    private long computeAndCheckBufferSize(int valueCount) {
        long size = this.computeCombinedBufferSize(valueCount, this.typeWidth);
        if (size > (long)MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Memory required for vector capacity " + valueCount + " is (" + size + "), which is more than max allowed (" + MAX_ALLOCATION_SIZE + ")");
        }
        return size;
    }

    private void allocateBytes(int valueCount) {
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(valueCount, this.typeWidth);
        this.valueBuffer = buffers.getDataBuf();
        this.validityBuffer = buffers.getValidityBuf();
        this.zeroVector();
        this.lastValueCapacity = this.getValueCapacity();
    }

    private void allocateValidityBuffer(int validityBufferSize) {
        this.validityBuffer = this.allocator.buffer(validityBufferSize);
        this.validityBuffer.readerIndex(0);
    }

    @Override
    public int getBufferSizeFor(int count) {
        if (count == 0) {
            return 0;
        }
        return count * this.typeWidth + BaseFixedWidthVector.getValidityBufferSizeFromCount(count);
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * this.typeWidth + BaseFixedWidthVector.getValidityBufferSizeFromCount(this.valueCount);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        this.setReaderAndWriterIndex();
        ArrowBuf[] buffers = this.getBufferSize() == 0 ? new ArrowBuf[]{} : new ArrowBuf[]{this.validityBuffer, this.valueBuffer};
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void reAlloc() {
        int targetValueCount = this.getValueCapacity() * 2;
        if (targetValueCount == 0) {
            targetValueCount = this.lastValueCapacity > 0 ? this.lastValueCapacity * 2 : 7940;
        }
        this.computeAndCheckBufferSize(targetValueCount);
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(targetValueCount, this.typeWidth);
        ArrowBuf newValueBuffer = buffers.getDataBuf();
        newValueBuffer.setBytes(0, this.valueBuffer, 0, this.valueBuffer.capacity());
        newValueBuffer.setZero(this.valueBuffer.capacity(), newValueBuffer.capacity() - this.valueBuffer.capacity());
        this.valueBuffer.release();
        this.valueBuffer = newValueBuffer;
        ArrowBuf newValidityBuffer = buffers.getValidityBuf();
        newValidityBuffer.setBytes(0, this.validityBuffer, 0, this.validityBuffer.capacity());
        newValidityBuffer.setZero(this.validityBuffer.capacity(), newValidityBuffer.capacity() - this.validityBuffer.capacity());
        this.validityBuffer.release();
        this.validityBuffer = newValidityBuffer;
        this.lastValueCapacity = this.getValueCapacity();
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("primitive type vector can not have children");
        }
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.emptyList();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 2) {
            throw new IllegalArgumentException("Illegal buffer count, expected 2, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        ArrowBuf dataBuffer = ownBuffers.get(1);
        this.validityBuffer.release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.valueBuffer.release();
        this.valueBuffer = dataBuffer.retain(this.allocator);
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(2);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.valueBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0);
        this.valueBuffer.readerIndex(0);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0);
            this.valueBuffer.writerIndex(0);
        } else {
            this.validityBuffer.writerIndex(BaseFixedWidthVector.getValidityBufferSizeFromCount(this.valueCount));
            if (this.typeWidth == 0) {
                this.valueBuffer.writerIndex(BaseFixedWidthVector.getValidityBufferSizeFromCount(this.valueCount));
            } else {
                this.valueBuffer.writerIndex(this.valueCount * this.typeWidth);
            }
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.name, allocator);
    }

    @Override
    public abstract TransferPair getTransferPair(String var1, BufferAllocator var2);

    public void transferTo(BaseFixedWidthVector target) {
        this.compareTypes(target, "transferTo");
        target.clear();
        target.validityBuffer = this.validityBuffer.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.valueBuffer = this.valueBuffer.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.valueCount = this.valueCount;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BaseFixedWidthVector target) {
        this.compareTypes(target, "splitAndTransferTo");
        target.clear();
        this.splitAndTransferValidityBuffer(startIndex, length, target);
        this.splitAndTransferValueBuffer(startIndex, length, target);
        target.setValueCount(length);
    }

    private void splitAndTransferValueBuffer(int startIndex, int length, BaseFixedWidthVector target) {
        int startPoint = startIndex * this.typeWidth;
        int sliceLength = length * this.typeWidth;
        target.valueBuffer = this.valueBuffer.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
    }

    private void splitAndTransferValidityBuffer(int startIndex, int length, BaseFixedWidthVector target) {
        assert (startIndex + length <= this.valueCount);
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BaseFixedWidthVector.getValidityBufferSizeFromCount(length);
        int offset = startIndex % 8;
        if (length > 0) {
            if (offset == 0) {
                if (target.validityBuffer != null) {
                    target.validityBuffer.release();
                }
                target.validityBuffer = this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                target.validityBuffer.retain(1);
            } else {
                byte b1;
                target.allocateValidityBuffer(byteSizeTarget);
                for (int i = 0; i < byteSizeTarget - 1; ++i) {
                    byte b12 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + i, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + i + 1, offset);
                    target.validityBuffer.setByte(i, b12 + b2);
                }
                if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                    target.validityBuffer.setByte(byteSizeTarget - 1, b1 + b2);
                } else {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    target.validityBuffer.setByte(byteSizeTarget - 1, b1);
                }
            }
        }
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        int currentValueCapacity = this.getValueCapacity();
        while (valueCount > this.getValueCapacity()) {
            this.reAlloc();
        }
        if (valueCount > 0) {
            if (currentValueCapacity >= valueCount * 2) {
                this.incrementAllocationMonitor();
            } else if (currentValueCapacity <= valueCount / 2) {
                this.decrementAllocationMonitor();
            }
        }
        this.setReaderAndWriterIndex();
    }

    public boolean isSafe(int index) {
        return index < this.getValueCapacity();
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public void setIndexDefined(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
    }

    public void set(int index, byte[] value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    public void setSafe(int index, byte[] value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    public void set(int index, ByteBuffer value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    public void setSafe(int index, ByteBuffer value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    protected void handleSafe(int index) {
        while (index >= this.getValueCapacity()) {
            this.decrementAllocationMonitor();
            this.reAlloc();
        }
    }
}

