/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.DateDayReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.DateDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class DateDayVector
extends BaseFixedWidthVector {
    private static final byte TYPE_WIDTH = 4;
    private final FieldReader reader = new DateDayReaderImpl(this);

    public DateDayVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.DATEDAY.getType()), allocator);
    }

    public DateDayVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 4);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DATEDAY;
    }

    public int get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getInt(index * 4);
    }

    public void get(int index, NullableDateDayHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getInt(index * 4);
    }

    @Override
    public Integer getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getInt(index * 4);
    }

    public void copyFrom(int fromIndex, int thisIndex, DateDayVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        int value = from.valueBuffer.getInt(fromIndex * 4);
        this.valueBuffer.setInt(thisIndex * 4, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, DateDayVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setInt(index * 4, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableDateDayHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, DateDayHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableDateDayHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, DateDayHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, int value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, int value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static int get(ArrowBuf buffer, int index) {
        return buffer.getInt(index * 4);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((DateDayVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        DateDayVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new DateDayVector(ref, DateDayVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(DateDayVector to) {
            this.to = to;
        }

        @Override
        public DateDayVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            DateDayVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            DateDayVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, DateDayVector.this);
        }
    }
}

