/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractCharCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractIterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BufferAllocationException;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.CharBufferVisualizer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.CharContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.CharLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.CharSet;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashContainers;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.Preallocable;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.CharCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.CharPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.CharProcedure;

public class CharHashSet
extends AbstractCharCollection
implements CharLookupContainer,
CharSet,
Preallocable,
Cloneable {
    public char[] keys;
    protected int assigned;
    protected int mask;
    protected int keyMixer;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public CharHashSet() {
        this(4, 0.75);
    }

    public CharHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharHashSet(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public CharHashSet(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public CharHashSet(CharContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(char key) {
        char existing;
        if (key == '\u0000') {
            assert (this.keys[this.mask + 1] == '\u0000');
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(char ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (char e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(CharContainer container) {
        this.ensureCapacity(container.size());
        return this.addAll((Iterable<? extends CharCursor>)container);
    }

    public int addAll(Iterable<? extends CharCursor> iterable) {
        int count = 0;
        for (CharCursor charCursor : iterable) {
            if (!this.add(charCursor.value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public char[] toArray() {
        char[] cloned = new char[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = '\u0000';
        }
        char[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            char existing = keys[slot];
            if (existing == '\u0000') continue;
            cloned[j++] = existing;
        }
        return cloned;
    }

    public boolean remove(char key) {
        char existing;
        if (key == '\u0000') {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int removeAll(char key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply('\u0000')) {
            this.hasEmptyKey = false;
        }
        char[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public boolean contains(char key) {
        char existing;
        if (key == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            char[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        char[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            char existing = keys[slot];
            if (existing == '\u0000') continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.sameKeys((CharSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(CharSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (CharCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public CharHashSet clone() {
        try {
            CharHashSet cloned = (CharHashSet)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<CharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharProcedure> T forEach(T procedure) {
        if (this.hasEmptyKey) {
            procedure.apply('\u0000');
        }
        char[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            char existing = keys[slot];
            if (existing == '\u0000') continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public <T extends CharPredicate> T forEach(T predicate) {
        char existing;
        if (this.hasEmptyKey && !predicate.apply('\u0000')) {
            return predicate;
        }
        char[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max && ((existing = keys[slot]) == '\u0000' || predicate.apply(existing)); ++slot) {
        }
        return predicate;
    }

    public static CharHashSet from(char ... elements) {
        CharHashSet set = new CharHashSet(elements.length);
        set.addAll(elements);
        return set;
    }

    protected int hashKey(char key) {
        assert (key != '\u0000');
        return BitMixer.mix(key, this.keyMixer);
    }

    public int indexOf(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public char indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index];
    }

    public char indexReplace(int index, char equivalentKey) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        assert (equivalentKey == this.keys[index]);
        char previousValue = this.keys[index];
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index, char key) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == '\u0000') {
            assert (index == this.mask + 1);
            assert (this.keys[index] == '\u0000');
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == '\u0000');
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key);
            } else {
                this.keys[index] = key;
            }
            ++this.assigned;
        }
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(char[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        char[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            char existing = fromKeys[i];
            if (existing == '\u0000') continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        char[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new char[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, char pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == '\u0000' && pendingKey != '\u0000');
        char[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        char[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    char existing = CharHashSet.this.keys[this.slot];
                    if (existing != '\u0000') {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && CharHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = '\u0000';
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

