/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractCharCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractDoubleCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractIterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BufferAllocationException;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.CharCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleBufferVisualizer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleCharAssociativeContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleCharMap;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashContainers;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.Preallocable;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.CharCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.DoubleCharCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.DoubleCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.CharPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.DoubleCharPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.DoublePredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.CharProcedure;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.DoubleCharProcedure;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.DoubleProcedure;

public class DoubleCharHashMap
implements DoubleCharMap,
Preallocable,
Cloneable {
    public double[] keys;
    public char[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public DoubleCharHashMap() {
        this(4);
    }

    public DoubleCharHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleCharHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public DoubleCharHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public DoubleCharHashMap(DoubleCharAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public char put(double key, char value) {
        double existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = true;
            char previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                char previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return '\u0000';
    }

    @Override
    public int putAll(DoubleCharAssociativeContainer container) {
        int count = this.size();
        for (DoubleCharCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends DoubleCharCursor> iterable) {
        int count = this.size();
        for (DoubleCharCursor doubleCharCursor : iterable) {
            this.put(doubleCharCursor.key, doubleCharCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(double key, char value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(double key, char putValue, char incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (char)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public char addTo(double key, char incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public char remove(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = false;
            char previousValue = this.values[mask + 1];
            this.values[mask + 1] = '\u0000';
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                char previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    @Override
    public int removeAll(DoubleContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof DoubleLookupContainer) {
            if (this.hasEmptyKey && other.contains(0.0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = '\u0000';
            }
            double[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                double existing = keys[slot];
                if (Double.doubleToLongBits(existing) != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (DoubleCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoubleCharPredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0.0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = '\u0000';
        }
        double[] keys = this.keys;
        char[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0.0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = '\u0000';
        }
        double[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public char get(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (char)'\u0000';
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    @Override
    public char getOrDefault(double key, char defaultValue) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public char indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public char indexReplace(int index, char newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        char previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, double key, char value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (Double.doubleToLongBits(key) == 0L) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (Double.doubleToLongBits(this.keys[index]) == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0.0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (DoubleCharCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((DoubleCharHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(DoubleCharHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (DoubleCharCursor c : other) {
            double key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            double[] prevKeys = this.keys;
            char[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<DoubleCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleCharProcedure> T forEach(T procedure) {
        double[] keys = this.keys;
        char[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0.0, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (Double.doubleToLongBits(keys[slot]) == 0L) continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends DoubleCharPredicate> T forEach(T predicate) {
        double[] keys = this.keys;
        char[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(0.0, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (Double.doubleToLongBits(keys[slot]) == 0L || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public CharCollection values() {
        return new ValuesContainer();
    }

    public DoubleCharHashMap clone() {
        try {
            DoubleCharHashMap cloned = (DoubleCharHashMap)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.values = (char[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleCharCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return DoubleBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static DoubleCharHashMap from(double[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleCharHashMap map = new DoubleCharHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(double key) {
        assert (Double.doubleToLongBits(key) != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(double[] fromKeys, char[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        double[] keys = this.keys;
        char[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            double existing = fromKeys[from];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        double[] prevKeys = this.keys;
        char[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new double[arraySize + emptyElementSlot];
            this.values = new char[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, double pendingKey, char pendingValue) {
        assert (this.assigned == this.resizeAt && Double.doubleToLongBits(this.keys[slot]) == 0L && Double.doubleToLongBits(pendingKey) != 0L);
        double[] prevKeys = this.keys;
        char[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        double existing;
        double[] keys = this.keys;
        char[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while (Double.doubleToLongBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        values[gapSlot] = '\u0000';
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = DoubleCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (Double.doubleToLongBits(DoubleCharHashMap.this.keys[this.slot]) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = DoubleCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = DoubleCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final DoubleCharHashMap owner;

        private ValuesContainer() {
            this.owner = DoubleCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            for (DoubleCharCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            for (DoubleCharCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            for (DoubleCharCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final char e) {
            return this.owner.removeAll(new DoubleCharPredicate(){

                @Override
                public boolean apply(double key, char value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final CharPredicate predicate) {
            return this.owner.removeAll(new DoubleCharPredicate(){

                @Override
                public boolean apply(double key, char value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = DoubleCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleCharHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0.0;
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleCharHashMap owner;

        public KeysContainer() {
            this.owner = DoubleCharHashMap.this;
        }

        @Override
        public boolean contains(double e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(final T procedure) {
            this.owner.forEach(new DoubleCharProcedure(){

                @Override
                public void apply(double key, char value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(final T predicate) {
            this.owner.forEach(new DoubleCharPredicate(){

                @Override
                public boolean apply(double key, char value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(double e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleCharCursor> {
        private final DoubleCharCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = DoubleCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCharCursor();
        }

        @Override
        protected DoubleCharCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleCharHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = DoubleCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0.0;
                this.cursor.value = DoubleCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleCharCursor)this.done();
        }
    }
}

