/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class IntToDateConverter
extends AbstractArrowVectorConverter {
    private IntVector intVector;

    public IntToDateConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.DATE.name(), fieldVector, columnIndex, context);
        this.intVector = (IntVector)fieldVector;
    }

    @Override
    public Date toDate(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        int val = this.intVector.getDataBuffer().getInt(index * 4);
        return ArrowResultUtil.getDate(val, TimeZone.getDefault(), this.context.getSession());
    }

    @Override
    public int toInt(int index) {
        if (this.isNull(index)) {
            return 0;
        }
        int val = this.intVector.getDataBuffer().getInt(index * 4);
        return val;
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        Date date = this.toDate(index);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getDateFormatter() == null) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.context.getSession(), new SFException(ErrorCode.INTERNAL_ERROR, "missing date formatter"), null, null);
        }
        Date date = this.toDate(index);
        return date == null ? null : ResultUtil.getDateAsString(date, this.context.getDateFormatter());
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toDate(index);
    }
}

