/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractIterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractLongCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ArraySizingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.LongContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.LongIndexedContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.Preallocable;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.LongCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.LongPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.LongProcedure;

public class LongArrayList
extends AbstractLongCollection
implements LongIndexedContainer,
Preallocable,
Cloneable {
    public static final long[] EMPTY_ARRAY = new long[0];
    public long[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public LongArrayList() {
        this(4);
    }

    public LongArrayList(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayList(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public LongArrayList(LongContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(long e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(long e1, long e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(long[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(long ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(LongContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (LongCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.add(longCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, long e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public long get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public long set(int index, long e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        long v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public long remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        long v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0L;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, 0L);
    }

    @Override
    public int removeFirst(long e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(long e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(long e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (this.buffer[from] == e1) {
                this.buffer[from] = 0L;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0L;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(long e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(long e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (this.buffer[i] != e1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (this.buffer[i] != e1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (expectedElements > bufferLen) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions > bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0L);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0L);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0L);
        this.elementsCount = 0;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public long[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public LongArrayList clone() {
        try {
            LongArrayList cloned = (LongArrayList)super.clone();
            cloned.buffer = (long[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((LongArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (other.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends LongProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        long[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(LongPredicate predicate) {
        int from;
        long[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = 0L;
                    continue;
                }
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = 0L;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = 0L;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends LongPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        long[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static LongArrayList from(long ... elements) {
        LongArrayList list = new LongArrayList(elements.length);
        list.add(elements);
        return list;
    }

    static final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final long[] buffer;
        private final int size;

        public ValueIterator(long[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected LongCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (LongCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

