/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.patterns;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.ExpressionOwner;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.objects.XObject;
import net.sourceforge.htmlunit.xpath.patterns.NodeTest;
import net.sourceforge.htmlunit.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    @Override
    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            for (StepPattern m_pattern : this.m_patterns) {
                if (!m_pattern.canTraverseOutsideSubtree()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
        if (null != patterns) {
            for (StepPattern pattern : patterns) {
                pattern.exprSetParent(this);
            }
        }
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        for (StepPattern m_pattern : this.m_patterns) {
            XObject score = m_pattern.execute(xctxt);
            if (score == NodeTest.SCORE_NONE) continue;
            if (null == bestScore) {
                bestScore = score;
                continue;
            }
            if (!(score.num() > bestScore.num())) continue;
            bestScore = score;
        }
        if (null == bestScore) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    @Override
    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitUnionPattern();
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            for (int i = 0; i < n; ++i) {
                this.m_patterns[i].callVisitors(new UnionPathPartOwner(i), visitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        UnionPattern up = (UnionPattern)expr;
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            if (null == up.m_patterns || up.m_patterns.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_patterns[i].deepEquals(up.m_patterns[i])) continue;
                return false;
            }
        } else if (up.m_patterns != null) {
            return false;
        }
        return true;
    }

    class UnionPathPartOwner
    implements ExpressionOwner {
        final int m_index;

        UnionPathPartOwner(int index) {
            this.m_index = index;
        }

        @Override
        public Expression getExpression() {
            return UnionPattern.this.m_patterns[this.m_index];
        }

        @Override
        public void setExpression(Expression exp) {
            exp.exprSetParent(UnionPattern.this);
            ((UnionPattern)UnionPattern.this).m_patterns[this.m_index] = (StepPattern)exp;
        }
    }
}

