/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.xml.dtm.ref;

import net.sourceforge.htmlunit.xpath.xml.dtm.DTMAxisIterator;
import net.sourceforge.htmlunit.xpath.xml.utils.WrappedRuntimeException;

public abstract class DTMAxisIteratorBase
implements DTMAxisIterator {
    protected int _last = -1;
    protected int _position = 0;
    protected int _markedNode;
    protected int _startNode = -1;
    protected boolean _includeSelf = false;
    protected boolean _isRestartable = true;

    @Override
    public void reset() {
        boolean temp = this._isRestartable;
        this._isRestartable = true;
        this.setStartNode(this._startNode);
        this._isRestartable = temp;
    }

    public DTMAxisIterator includeSelf() {
        this._includeSelf = true;
        return this;
    }

    @Override
    public int getLast() {
        if (this._last == -1) {
            int temp = this._position;
            this.setMark();
            this.reset();
            do {
                ++this._last;
            } while (this.next() != -1);
            this.gotoMark();
            this._position = temp;
        }
        return this._last;
    }

    @Override
    public int getPosition() {
        return this._position == 0 ? 1 : this._position;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    public DTMAxisIterator cloneIterator() {
        try {
            DTMAxisIteratorBase clone = (DTMAxisIteratorBase)super.clone();
            clone._isRestartable = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    protected final int returnNode(int node) {
        ++this._position;
        return node;
    }

    protected final void resetPosition() {
        this._position = 0;
    }
}

