/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.log4j;

import java.util.Date;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SMTPAppender;
import org.apache.log4j.spi.LoggingEvent;

public class DynamicSubjectSMTPAppender
extends SMTPAppender {
    private Layout subjectLayout;

    public void setSubject(String subjectPattern) {
        this.subjectLayout = new PatternLayout(subjectPattern);
    }

    protected void sendBuffer() {
        try {
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String t = this.layout.getHeader();
            if (t != null) {
                sbuf.append(t);
            }
            int len = this.cb.length();
            for (int i = 0; i < len; ++i) {
                String[] s;
                LoggingEvent event = this.cb.get();
                if (this.subjectLayout != null) {
                    String subject = this.subjectLayout.format(event);
                    this.msg.setSubject(subject);
                }
                sbuf.append(this.layout.format(event));
                if (!this.layout.ignoresThrowable() || (s = event.getThrowableStrRep()) == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    sbuf.append(s[j]);
                }
            }
            t = this.layout.getFooter();
            if (t != null) {
                sbuf.append(t);
            }
            part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            this.msg.setContent((Multipart)mp);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception e) {
            LogLog.error((String)"Error occured while sending e-mail notification.", (Throwable)e);
        }
    }
}

