/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.core.AbstractTask;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.url.Url;

public class TaskGroup
extends AbstractTask
implements Task {
    private final TaskGroup parent;
    private final List<Task> children = new ArrayList<Task>();

    public TaskGroup(TaskGroup parent, StyleBuilder styleBuilder, String name) {
        super(styleBuilder, new TaskCode(name));
        this.parent = parent;
    }

    @Override
    public Day getStart() {
        Day min = null;
        for (Task child : this.children) {
            if (min != null && min.compareTo(child.getStart()) <= 0) continue;
            min = child.getStart();
        }
        if (min != null) {
            return min;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Day getEnd() {
        Day max = null;
        for (Task child : this.children) {
            if (max != null && max.compareTo(child.getEnd()) >= 0) continue;
            max = child.getEnd();
        }
        if (max != null) {
            return max;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStart(Day start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEnd(Day end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setColors(CenterBorderColor ... colors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addResource(Resource resource, int percentage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Load getLoad() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoad(Load load) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDiamond(boolean diamond) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDiamond() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCompletion(int completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUrl(Url url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPause(Day pause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPause(DayOfWeek pause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNote(Display note) {
    }

    public void addTask(Task child) {
        this.children.add(child);
    }

    public final TaskGroup getParent() {
        return this.parent;
    }

    @Override
    public boolean isAssignedTo(Resource res) {
        return false;
    }
}

