/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class Getenv
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%getenv", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        String value = this.getenv(values.get(0).toString());
        if (value == null) {
            return TValue.fromString("");
        }
        return TValue.fromString(value);
    }

    private String getenv(String name) {
        if (!SecurityUtils.getSecurityProfile().canWeReadThisEnvironmentVariable(name)) {
            return null;
        }
        String env = System.getProperty(name);
        if (env != null) {
            return env;
        }
        return System.getenv(name);
    }
}

