/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.Collections;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockInEllipse;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.url.Url;

public class EntityImageChenAttribute
extends AbstractEntityImage {
    private static final int MARGIN = 6;
    private final boolean isKey = this.hasStereotype("<<key>>");
    private final boolean isMulti = this.hasStereotype("<<multi>>");
    private final boolean isDerived = this.hasStereotype("<<derived>>");
    private final TextBlock title;
    private final Url url;

    public EntityImageChenAttribute(Entity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        FontConfiguration titleFontConfiguration = EntityImageChenAttribute.getStyleTitle(entity, skinParam).getFontConfiguration(this.getSkinParam().getIHtmlColorSet(), entity.getColors());
        if (this.isKey) {
            titleFontConfiguration = titleFontConfiguration.underline();
        }
        this.title = entity.getDisplay().create8(titleFontConfiguration, HorizontalAlignment.CENTER, skinParam, CreoleMode.FULL, this.getStyle().wrapWidth());
        this.url = entity.getUrl99();
    }

    private boolean hasStereotype(String stereotype) {
        return this.getEntity().getStereotype() != null && this.getEntity().getStereotype().toString().contains(stereotype);
    }

    private Style getStyle() {
        return EntityImageChenAttribute.getStyle(this.getEntity(), this.getSkinParam());
    }

    private static Style getStyle(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chenEerDiagram, SName.chenAttribute).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    private static Style getStyleTitle(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chenEerDiagram, SName.chenAttribute, SName.title).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        TextBlockInEllipse ellipse = new TextBlockInEllipse(this.title, stringBounder);
        return ellipse.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.startGroup(Collections.singletonMap(UGroupType.ID, this.getEntity().getQuark().toStringPoint()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        XDimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        XDimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        UStroke stroke = this.getStyle().getStroke(this.getEntity().getColors());
        if (this.isDerived) {
            stroke = new UStroke(10.0, 10.0, stroke.getThickness());
        }
        ug = this.applyColor(ug);
        ug = ug.apply(stroke);
        ug.draw(this.getShape(dimTotal));
        if (this.isMulti) {
            ug.apply(new UTranslate(3.0, 3.0)).draw(this.getShape(dimTotal.delta(-6.0)));
        }
        double xTitle = (dimTotal.getWidth() - dimTitle.getWidth()) / 2.0;
        double yTitle = 6.0;
        this.title.drawU(ug.apply(new UTranslate(xTitle, 6.0)));
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    protected final UGraphic applyColor(UGraphic ug) {
        Colors colors = this.getEntity().getColors();
        HColor border = colors.getColor(ColorType.LINE);
        if (border == null) {
            border = this.getStyle().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(border);
        HColor backcolor = colors.getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = this.getStyle().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(backcolor.bg());
        return ug;
    }

    private UShape getShape(XDimension2D dimTotal) {
        return UEllipse.build(dimTotal.getWidth(), dimTotal.getHeight());
    }
}

