/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class ResourceDrawBasic
implements ResourceDraw {
    private final Resource res;
    private final TimeScale timeScale;
    private final double y;
    private final Day min;
    private final Day max;
    private final GanttDiagram gantt;

    public ResourceDrawBasic(GanttDiagram gantt, Resource res, TimeScale timeScale, double y, Day min, Day max) {
        this.res = res;
        this.timeScale = timeScale;
        this.y = y;
        this.min = min;
        this.max = max;
        this.gantt = gantt;
    }

    @Override
    public void drawU(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.res.getName()).create(this.getFontConfiguration(13), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        title.drawU(ug);
        ULine line = ULine.hline(this.timeScale.getEndingPosition(this.max) - this.timeScale.getStartingPosition(this.min));
        ug.apply(HColors.BLACK).apply(UTranslate.dy(title.calculateDimension(ug.getStringBounder()).getHeight())).draw(line);
        double startingPosition = -1.0;
        int totalLoad = 0;
        int totalLimit = 0;
        Day i = this.min;
        while (i.compareTo(this.max) <= 0) {
            boolean isBreaking = this.timeScale.isBreaking(i);
            totalLoad += this.gantt.getLoadForResource(this.res, i);
            totalLimit += 100;
            if (isBreaking) {
                if (totalLoad > 0) {
                    boolean over = totalLoad > totalLimit;
                    FontConfiguration fontConfiguration = this.getFontConfiguration(9, over ? HColors.RED : HColors.BLACK);
                    TextBlock value = Display.getWithNewlines("" + totalLoad).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                    if (startingPosition == -1.0) {
                        startingPosition = this.timeScale.getStartingPosition(i);
                    }
                    double endingPosition = this.timeScale.getEndingPosition(i);
                    double start = (startingPosition + endingPosition) / 2.0 - value.calculateDimension(ug.getStringBounder()).getWidth() / 2.0;
                    value.drawU(ug.apply(new UTranslate(start, 16.0)));
                }
                startingPosition = -1.0;
                totalLoad = 0;
                totalLimit = 0;
            } else if (startingPosition == -1.0) {
                startingPosition = this.timeScale.getStartingPosition(i);
            }
            i = i.increment();
        }
    }

    private FontConfiguration getFontConfiguration(int size) {
        return this.getFontConfiguration(size, HColors.BLACK);
    }

    private FontConfiguration getFontConfiguration(int size, HColor color) {
        UFont font = UFont.serif(size);
        return FontConfiguration.create(font, color, color, null);
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        return 32.0;
    }

    @Override
    public final double getY() {
        return this.y;
    }
}

