/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.stream.Stream;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JjtreeNode;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavadocComment;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.util.IteratorUtil;

public class JavaComment
implements Reportable {
    private final JavaccToken token;

    JavaComment(JavaccToken t) {
        this.token = t;
    }

    public FileLocation getReportLocation() {
        return this.getToken().getReportLocation();
    }

    public final JavaccToken getToken() {
        return this.token;
    }

    public boolean isSingleLine() {
        return this.token.kind == 4;
    }

    public boolean hasJavadocContent() {
        return this.token.kind == 7;
    }

    public Chars getText() {
        return this.getToken().getImageCs();
    }

    public static boolean isComment(JavaccToken token) {
        return JavaAstUtils.isComment(token);
    }

    public Iterable<Chars> getFilteredLines() {
        return this.getFilteredLines(false);
    }

    public Iterable<Chars> getFilteredLines(boolean preserveEmptyLines) {
        if (preserveEmptyLines) {
            return () -> IteratorUtil.map(this.getText().lines().iterator(), JavaComment::removeCommentMarkup);
        }
        return () -> IteratorUtil.mapNotNull(this.getText().lines().iterator(), line -> (line = JavaComment.removeCommentMarkup(line)).isEmpty() ? null : line);
    }

    public static boolean isMarkupWord(Chars word) {
        return word.length() <= 3 && (word.contentEquals((CharSequence)"*") || word.contentEquals((CharSequence)"//") || word.contentEquals((CharSequence)"/*") || word.contentEquals((CharSequence)"*/") || word.contentEquals((CharSequence)"/**"));
    }

    public static Chars removeCommentMarkup(Chars line) {
        line = line.trim().removeSuffix("*/");
        int subseqFrom = 0;
        if (line.startsWith('/', 0)) {
            if (line.startsWith("**", 1)) {
                subseqFrom = 3;
            } else if (line.startsWith('/', 1) || line.startsWith('*', 1)) {
                subseqFrom = 2;
            }
        } else if (line.startsWith('*', 0)) {
            subseqFrom = 1;
        }
        return line.subSequence(subseqFrom, line.length()).trim();
    }

    private static Stream<JavaccToken> getSpecialTokensIn(JjtreeNode<?> node) {
        return GenericToken.streamRange((GenericToken)node.getFirstToken(), (GenericToken)node.getLastToken()).flatMap(it -> IteratorUtil.toStream(GenericToken.previousSpecials((GenericToken)it).iterator()));
    }

    public static Stream<JavaComment> getLeadingComments(JavaNode node) {
        Stream<JavaccToken> specialTokens;
        if (node instanceof ModifierOwner) {
            node = ((ModifierOwner)node).getModifiers();
            specialTokens = JavaComment.getSpecialTokensIn(node);
            if (!node.getFirstToken().isImplicit()) {
                specialTokens = Stream.concat(specialTokens, JavaComment.getSpecialTokensIn((JjtreeNode)node.getNextSibling()));
            }
        } else {
            specialTokens = JavaComment.getSpecialTokensIn(node);
        }
        return specialTokens.filter(JavaComment::isComment).map(JavaComment::toComment);
    }

    private static JavaComment toComment(JavaccToken tok) {
        switch (tok.kind) {
            case 7: {
                return new JavadocComment(tok);
            }
            case 4: 
            case 8: {
                return new JavaComment(tok);
            }
        }
        throw new IllegalArgumentException("Token is not a comment: " + tok);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaComment)) {
            return false;
        }
        JavaComment that = (JavaComment)o;
        return this.token.equals(that.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }
}

