/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.coreimpl;

import java.util.List;
import java.util.function.BinaryOperator;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChain;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNode;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;

class ShadowChainNodeBase<S, I>
implements ShadowChain<S, I>,
ShadowChainNode<S, I> {
    protected final NameResolver<S> resolver;
    private final BinaryOperator<List<S>> merger;
    protected final @NonNull ShadowChainNode<S, I> parent;
    private final boolean shadowBarrier;
    private final I scopeTag;

    ShadowChainNodeBase(@NonNull ShadowChainNode<S, I> parent, boolean shadowBarrier, I scopeTag, NameResolver<? extends S> resolver, BinaryOperator<List<S>> merger) {
        this.parent = parent;
        this.scopeTag = scopeTag;
        this.shadowBarrier = shadowBarrier;
        this.resolver = resolver;
        this.merger = merger;
    }

    ShadowChainNodeBase(ShadowChainNode<S, I> parent, boolean shadowBarrier, I scopeTag, NameResolver<? extends S> resolver) {
        this(parent, shadowBarrier, scopeTag, resolver, ShadowChainNodeBase.defaultMerger());
    }

    @Override
    public ShadowChainNode<S, I> asNode() {
        return this;
    }

    @Override
    public ShadowChain<S, I> asChain() {
        return this;
    }

    @Override
    public NameResolver<S> getResolver() {
        return this.resolver;
    }

    @Override
    public final boolean isShadowBarrier() {
        return this.shadowBarrier;
    }

    @Override
    public @NonNull ShadowChainNode<S, I> getParent() {
        return this.parent;
    }

    I getScopeTag() {
        return this.scopeTag;
    }

    @Override
    public OptionalBool knowsSymbol(String simpleName) {
        return this.resolver.knows(simpleName);
    }

    @Override
    public @NonNull List<S> resolve(String name) {
        List res = this.resolveHere(name);
        if (res.isEmpty()) {
            return this.getParent().asChain().resolve(name);
        }
        ShadowChainNode<S, I> node = this;
        while (!node.isShadowBarrier() && node.getParent() != null) {
            node = node.getParent();
            res = (List)this.merger.apply(res, node.resolveHere(name));
        }
        return res;
    }

    @Override
    public List<S> resolveHere(String simpleName) {
        List<S> res = this.resolver.resolveHere(simpleName);
        this.handleResolverKnows(simpleName, !res.isEmpty());
        return res;
    }

    protected void handleResolverKnows(String name, boolean resolverKnows) {
    }

    @Override
    public S resolveFirst(String name) {
        S sym = this.resolver.resolveFirst(name);
        this.handleResolverKnows(name, sym != null);
        return sym != null ? sym : this.getParent().asChain().resolveFirst(name);
    }

    public String toString() {
        return this.scopeTag + "  " + this.resolver.toString();
    }

    static <S> BinaryOperator<List<S>> defaultMerger() {
        return CollectionUtil::concatView;
    }
}

