/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import java.math.BigDecimal;
import net.sourceforge.pmd.lang.ecmascript.ast.AbstractEcmascriptNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptVisitor;
import org.mozilla.javascript.ast.NumberLiteral;

public final class ASTNumberLiteral
extends AbstractEcmascriptNode<NumberLiteral> {
    ASTNumberLiteral(NumberLiteral numberLiteral) {
        super(numberLiteral);
    }

    @Override
    protected <P, R> R acceptJsVisitor(EcmascriptVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public String getNormalizedImage() {
        String image = this.getValue();
        image = image.replaceAll("_", "");
        image = this.normalizeHexIntegerLiteral(image);
        image = this.normalizeBinaryLiteral(image);
        image = this.normalizeOctalLiteral(image);
        if ((image = image.replace('e', 'E')).indexOf(46) == -1 && image.indexOf(69) == -1) {
            image = image + ".0";
        }
        return image;
    }

    private String normalizeHexIntegerLiteral(String image) {
        if (image.startsWith("0x") || image.startsWith("0X")) {
            return String.valueOf(Integer.parseInt(image.substring(2), 16));
        }
        return image;
    }

    private String normalizeBinaryLiteral(String image) {
        if (image.startsWith("0b") || image.startsWith("0B")) {
            return String.valueOf(Integer.parseInt(image.substring(2), 2));
        }
        return image;
    }

    private String normalizeOctalLiteral(String image) {
        if (image.startsWith("0o") || image.startsWith("0O")) {
            return String.valueOf(Integer.parseInt(image.substring(2), 8));
        }
        return image;
    }

    public double getNumber() {
        return ((NumberLiteral)this.node).getNumber();
    }

    public String getValue() {
        return ((NumberLiteral)this.node).getValue();
    }

    public boolean isInaccurate() {
        BigDecimal converted;
        BigDecimal bigDecimal = new BigDecimal(this.getNormalizedImage());
        return bigDecimal.compareTo(converted = BigDecimal.valueOf(bigDecimal.doubleValue())) != 0;
    }
}

