/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.outbound.lookup;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.List;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.lookup.LookupService;
import network.oxalis.api.util.Type;
import network.oxalis.vefa.peppol.common.lang.EndpointNotFoundException;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.lookup.LookupClient;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

@Singleton
@Type(value={"default"})
class DefaultLookupService
implements LookupService {
    private final LookupClient lookupClient;
    private final TransportProfile[] transportProfiles;

    @Inject
    public DefaultLookupService(LookupClient lookupClient, @Named(value="prioritized") List<TransportProfile> transportProfiles) {
        this.lookupClient = lookupClient;
        this.transportProfiles = transportProfiles.toArray(new TransportProfile[transportProfiles.size()]);
    }

    public Endpoint lookup(Header header) throws OxalisTransmissionException {
        try {
            return this.lookupClient.getEndpoint(header, this.transportProfiles);
        }
        catch (EndpointNotFoundException | LookupException | PeppolSecurityException e) {
            throw new OxalisTransmissionException(e.getMessage(), e);
        }
    }
}

