/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.lib.geotools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeometryTools {
    private static GeometryFactory geometryFactory;
    private static final double ACREAGE_DEVIDER = 10000.0;

    private static GeometryFactory getGeometryFactory() {
        if (geometryFactory != null) {
            return geometryFactory;
        }
        geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        return geometryFactory;
    }

    public static Geometry wktToGeometry(String wkt) {
        try {
            WKTReader wKTReader = new WKTReader(GeometryTools.getGeometryFactory());
            return wKTReader.read(wkt);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Provided argumment " + wkt + " did not contain a parseable geometry ", ex);
        }
    }

    public static Point getPoint(GeometryFactory geometryFactory, double longitude, double latitude) {
        Coordinate coordinate = new Coordinate(longitude, latitude);
        Point geometry = geometryFactory.createPoint(coordinate);
        return geometry;
    }

    public static Point getPoint(double longitude, double latitude) {
        return GeometryTools.getPoint(GeometryTools.getGeometryFactory(), longitude, latitude);
    }

    public static Double getAcreageInHA(Double acreage) {
        return acreage > 0.0 ? acreage / 10000.0 : acreage;
    }

    public static Double getAcreageFromGeometry(Geometry geometry) {
        Geometry transFormed = null;
        Double faultValue = new Double(0.0);
        String netherlandsWKT = "MULTIPOLYGON (((3.10000 51.20000, 3.10000 53.55000, 7.210000 53.55000, 7.21000 50.70000, 3.10000 51.20000)))";
        Geometry netherLands = GeometryTools.wktToGeometry(netherlandsWKT);
        if (netherLands.contains(geometry)) {
            try {
                CoordinateReferenceSystem sourceReference = CRS.decode((String)"CRS:84");
                CoordinateReferenceSystem targetReference = CRS.decode((String)"EPSG:28992");
                CoordinateOperation coFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)GeoTools.getDefaultHints()).createOperation(sourceReference, targetReference);
                transFormed = JTS.transform((Geometry)geometry, (MathTransform)coFactory.getMathTransform());
                return transFormed.getArea();
            }
            catch (TransformException ex) {
                return faultValue;
            }
            catch (MismatchedDimensionException ex) {
                return faultValue;
            }
            catch (NoSuchAuthorityCodeException ex) {
                return faultValue;
            }
            catch (FactoryException ex) {
                return faultValue;
            }
        }
        return faultValue;
    }
}

