/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.plugins.maven.javassist;

import com.google.common.base.Predicate;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import nl.topicus.plugins.maven.javassist.ClassFileIterator;
import org.sonatype.plexus.build.incremental.BuildContext;

public class ClassNameDirectoryIterator
implements ClassFileIterator {
    private final String classPath;
    private Iterator<File> classFiles = new ArrayList().iterator();
    private File lastFile;

    public ClassNameDirectoryIterator(String classPath, final BuildContext buildContext) {
        this.classPath = classPath;
        this.classFiles = Files.fileTreeTraverser().preOrderTraversal((Object)new File(classPath)).filter((Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return "class".equals(Files.getFileExtension((String)input.getName())) && buildContext.hasDelta(input);
            }
        }).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.classFiles.hasNext();
    }

    @Override
    public String next() {
        File classFile;
        this.lastFile = classFile = this.classFiles.next();
        try {
            String qualifiedFileName = classFile.getCanonicalPath().substring(this.classPath.length() + 1);
            return Files.getNameWithoutExtension((String)qualifiedFileName.replace(File.separator, "."));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public File getLastFile() {
        return this.lastFile;
    }

    @Override
    public void remove() {
        this.classFiles.remove();
    }
}

