/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.plugins.maven.javassist;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import nl.topicus.plugins.maven.javassist.ClassFileIterator;
import org.sonatype.plexus.build.incremental.BuildContext;

public class ClassNameJarIterator
implements ClassFileIterator {
    private Iterator<String> classFiles = new ArrayList().iterator();
    private File jarFile;

    public ClassNameJarIterator(String classPath, BuildContext buildContext) {
        this.jarFile = new File(classPath);
        if (buildContext.hasDelta(classPath)) {
            ArrayList<String> classNames = new ArrayList<String>();
            try {
                JarEntry jarEntry;
                JarInputStream jarFileStream = new JarInputStream(new FileInputStream(this.jarFile));
                while ((jarEntry = jarFileStream.getNextJarEntry()) != null) {
                    if (!jarEntry.getName().endsWith(".class")) continue;
                    classNames.add(jarEntry.getName().replaceAll("/", "\\."));
                }
                jarFileStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.classFiles = classNames.iterator();
        } else {
            this.classFiles = Collections.emptyIterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.classFiles.hasNext();
    }

    @Override
    public String next() {
        return Files.getNameWithoutExtension((String)this.classFiles.next()).replace(File.separator, ".");
    }

    @Override
    public File getLastFile() {
        return this.jarFile;
    }

    @Override
    public void remove() {
        this.classFiles.remove();
    }
}

