/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.plugins.maven.javassist;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import nl.topicus.plugins.maven.javassist.ClassFileIterator;
import nl.topicus.plugins.maven.javassist.ClassNameDirectoryIterator;
import nl.topicus.plugins.maven.javassist.ClassNameJarIterator;
import nl.topicus.plugins.maven.javassist.ClassTransformer;
import nl.topicus.plugins.maven.javassist.ILogger;
import nl.topicus.plugins.maven.javassist.TransformationException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="javassist", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JavassistMojo
extends AbstractMojo
implements ILogger {
    private static final Class<ClassTransformer> TRANSFORMER_TYPE = ClassTransformer.class;
    @Component
    private BuildContext buildContext;
    @Parameter(property="project", defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="transformerClass", required=true)
    private String transformerClass;
    @Parameter(property="processInclusions", required=true)
    private List<String> processInclusions;
    @Parameter(property="processExclusions")
    private List<String> processExclusions;
    @Parameter(property="exclusions")
    private List<String> exclusions;
    @Parameter(property="outputDirectory", defaultValue="${project.build.outputDirectory}")
    private String outputDirectory;

    public void execute() throws MojoExecutionException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List<String> classpathElements = this.getCompileClasspathElements();
            this.loadClassPath(originalContextClassLoader, this.generateClassPathUrls(classpathElements));
            this.transform(classpathElements);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    public final void transform(List<String> classPaths) throws MojoExecutionException {
        int errors = 0;
        if (classPaths.isEmpty()) {
            return;
        }
        ClassTransformer transformer = this.instantiateTransformerClass();
        ClassPool classPool = new ClassPool(ClassPool.getDefault());
        classPool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
        for (String classPath : classPaths) {
            this.debug("Processing " + classPath);
            ClassFileIterator classNames = this.createClassNameIterator(classPath);
            while (classNames.hasNext()) {
                String className = (String)classNames.next();
                try {
                    CtClass candidateClass = classPool.get(className);
                    if (candidateClass.isFrozen() || !transformer.processClassName(className)) {
                        this.debug("Skipping " + className);
                        continue;
                    }
                    transformer.applyTransformations(classPool, candidateClass);
                    this.writeFile(candidateClass, this.outputDirectory);
                }
                catch (TransformationException e) {
                    ++errors;
                    this.addMessage(classNames.getLastFile(), 1, 1, e.getMessage(), null);
                }
                catch (NotFoundException e) {
                    ++errors;
                    this.addMessage(classNames.getLastFile(), 1, 1, String.format("Class %s could not be resolved due to dependencies not found on current classpath.", className), e);
                }
                catch (Exception e) {
                    ++errors;
                    this.addMessage(classNames.getLastFile(), 1, 1, String.format("Class %s could not be transformed.", className), e);
                }
            }
        }
        if (errors > 0) {
            throw new MojoExecutionException(errors + " errors found during transformation.");
        }
    }

    public void writeFile(CtClass candidateClass, String targetDirectory) throws Exception {
        String dir;
        candidateClass.getClassFile().compact();
        candidateClass.rebuildClassFile();
        String classname = candidateClass.getName();
        String filename = targetDirectory + File.separatorChar + classname.replace('.', File.separatorChar) + ".class";
        int pos = filename.lastIndexOf(File.separatorChar);
        if (pos > 0 && !(dir = filename.substring(0, pos)).equals(".")) {
            File outputDir = new File(dir);
            outputDir.mkdirs();
            this.buildContext.refresh(outputDir);
        }
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.buildContext.newFileOutputStream(new File(filename))));){
            candidateClass.toBytecode(out);
        }
    }

    private ClassFileIterator createClassNameIterator(String classPath) {
        if (new File(classPath).isDirectory()) {
            return new ClassNameDirectoryIterator(classPath, this.buildContext);
        }
        return new ClassNameJarIterator(classPath, this.buildContext);
    }

    private List<String> getCompileClasspathElements() throws DependencyResolutionRequiredException {
        List ret = this.project.getCompileClasspathElements();
        ret.remove(this.project.getBuild().getOutputDirectory());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)ret, String.class));
    }

    protected ClassTransformer instantiateTransformerClass() throws MojoExecutionException {
        Class<?> transformerClassInstance;
        if (this.transformerClass == null || this.transformerClass.trim().isEmpty()) {
            throw new MojoExecutionException("Invalid transformer class name passed");
        }
        try {
            transformerClassInstance = Class.forName(this.transformerClass.trim(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        ClassTransformer transformerInstance = null;
        if (TRANSFORMER_TYPE.isAssignableFrom(transformerClassInstance)) {
            try {
                transformerInstance = TRANSFORMER_TYPE.cast(transformerClassInstance.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else {
            throw new MojoExecutionException("Transformer class must inherit from " + TRANSFORMER_TYPE.getName());
        }
        transformerInstance.setLogger((ILogger)this);
        transformerInstance.setProcessInclusions(this.processInclusions);
        transformerInstance.setProcessExclusions(this.processExclusions);
        transformerInstance.setExclusions(this.exclusions);
        return transformerInstance;
    }

    private List<URL> generateClassPathUrls(Iterable<String> classpathElements) {
        ArrayList<URL> classPath = new ArrayList<URL>();
        for (String runtimeResource : classpathElements) {
            URL url = this.resolveUrl(runtimeResource);
            if (url == null) continue;
            classPath.add(url);
        }
        return classPath;
    }

    private void loadClassPath(ClassLoader contextClassLoader, List<URL> urls) {
        if (urls.size() <= 0) {
            return;
        }
        URLClassLoader pluginClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), contextClassLoader);
        Thread.currentThread().setContextClassLoader(pluginClassLoader);
    }

    private URL resolveUrl(String resource) {
        try {
            return new File(resource).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void addMessage(File file, int line, int pos, String message, Throwable e) {
        this.buildContext.addMessage(file, line, pos, message, 2, e);
    }

    public void debug(String message) {
        this.getLog().info((CharSequence)message);
    }

    public void debug(String message, Throwable throwable) {
        this.getLog().info((CharSequence)message, throwable);
    }

    public void info(String message) {
        this.getLog().info((CharSequence)message);
    }

    public void info(String message, Throwable throwable) {
        this.getLog().info((CharSequence)message, throwable);
    }

    public void warn(String message) {
        this.getLog().warn((CharSequence)message);
    }

    public void warn(String message, Throwable throwable) {
        this.getLog().warn((CharSequence)message, throwable);
    }

    public void error(String message) {
        this.getLog().error((CharSequence)message);
    }

    public void error(String message, Throwable throwable) {
        this.getLog().error((CharSequence)message, throwable);
    }
}

