/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMLObject
implements XMLObject {
    private final Logger log = Logger.getLogger(AbstractXMLObject.class);
    private XMLObject parent;
    private QName elementQname;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private QName typeQname;
    private Set<Namespace> namespaces;
    private Element dom;
    private final IDIndex idIndex = new IDIndex(this);

    protected AbstractXMLObject(String namespaceURI, String elementLocalName, String namespacePrefix) {
        this.namespaces = new HashSet<Namespace>();
        this.elementQname = XMLHelper.constructQName(namespaceURI, elementLocalName, namespacePrefix);
        this.addNamespace(new Namespace(namespaceURI, namespacePrefix));
        this.setElementNamespacePrefix(namespacePrefix);
    }

    @Override
    public QName getElementQName() {
        return new QName(this.elementQname.getNamespaceURI(), this.elementQname.getLocalPart(), this.elementQname.getPrefix());
    }

    protected void setElementQName(QName elementQName) {
        this.elementQname = XMLHelper.constructQName(elementQName.getNamespaceURI(), elementQName.getLocalPart(), elementQName.getPrefix());
        this.addNamespace(new Namespace(elementQName.getNamespaceURI(), elementQName.getLocalPart()));
    }

    public void setElementNamespacePrefix(String prefix) {
        this.elementQname = prefix == null ? new QName(this.elementQname.getNamespaceURI(), this.elementQname.getLocalPart()) : new QName(this.elementQname.getNamespaceURI(), this.elementQname.getLocalPart(), prefix);
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return Collections.unmodifiableSet(this.namespaces);
    }

    @Override
    public void addNamespace(Namespace namespace) {
        if (namespace != null) {
            this.namespaces.add(namespace);
        }
    }

    @Override
    public void removeNamespace(Namespace namespace) {
        this.namespaces.remove(namespace);
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String location) {
        this.schemaLocation = DatatypeHelper.safeTrimOrNullString(location);
    }

    @Override
    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    @Override
    public void setNoNamespaceSchemaLocation(String location) {
        this.noNamespaceSchemaLocation = DatatypeHelper.safeTrimOrNullString(location);
    }

    @Override
    public QName getSchemaType() {
        return this.typeQname;
    }

    protected void setSchemaType(QName type) {
        if (type == null) {
            this.typeQname = null;
        } else {
            this.typeQname = type;
            this.addNamespace(new Namespace(type.getNamespaceURI(), type.getPrefix()));
        }
    }

    @Override
    public XMLObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XMLObject newParent) {
        this.parent = newParent;
    }

    @Override
    public boolean hasParent() {
        return this.getParent() != null;
    }

    @Override
    public boolean hasChildren() {
        List<XMLObject> children = this.getOrderedChildren();
        return children != null && children.size() > 0;
    }

    @Override
    public Element getDOM() {
        return this.dom;
    }

    @Override
    public void setDOM(Element newDom) {
        this.dom = newDom;
    }

    @Override
    public void releaseDOM() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing cached DOM reprsentation for " + this.getElementQName()));
        }
        this.setDOM(null);
    }

    @Override
    public void releaseParentDOM(boolean propagateRelease) {
        XMLObject parentElement;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing cached DOM reprsentation for parent of " + this.getElementQName() + " with propagation set to " + propagateRelease));
        }
        if ((parentElement = this.getParent()) != null) {
            this.parent.releaseDOM();
            if (propagateRelease) {
                this.parent.releaseParentDOM(propagateRelease);
            }
        }
    }

    @Override
    public void releaseChildrenDOM(boolean propagateRelease) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing cached DOM reprsentation for children of " + this.getElementQName() + " with propagation set to " + propagateRelease));
        }
        if (this.getOrderedChildren() != null) {
            for (XMLObject child : this.getOrderedChildren()) {
                if (child == null) continue;
                child.releaseDOM();
                if (!propagateRelease) continue;
                child.releaseChildrenDOM(propagateRelease);
            }
        }
    }

    public void releaseThisandParentDOM() {
        if (this.getDOM() != null) {
            this.releaseDOM();
            this.releaseParentDOM(true);
        }
    }

    public void releaseThisAndChildrenDOM() {
        if (this.getDOM() != null) {
            this.releaseDOM();
            this.releaseChildrenDOM(true);
        }
    }

    protected String prepareForAssignment(String oldValue, String newValue) {
        String newString = DatatypeHelper.safeTrimOrNullString(newValue);
        if (!DatatypeHelper.safeEquals(oldValue, newString)) {
            this.releaseThisandParentDOM();
        }
        return newString;
    }

    protected QName prepareForAssignment(QName oldValue, QName newValue) {
        if (oldValue == null) {
            if (newValue != null) {
                Namespace newNamespace = new Namespace(newValue.getNamespaceURI(), newValue.getPrefix());
                this.addNamespace(newNamespace);
                this.releaseThisandParentDOM();
                return newValue;
            }
            return null;
        }
        if (!oldValue.equals(newValue)) {
            if (newValue != null) {
                Namespace newNamespace = new Namespace(newValue.getNamespaceURI(), newValue.getPrefix());
                this.addNamespace(newNamespace);
            }
            this.releaseThisandParentDOM();
        }
        return newValue;
    }

    protected <T> T prepareForAssignment(T oldValue, T newValue) {
        if (oldValue == null) {
            if (newValue != null) {
                this.releaseThisandParentDOM();
                return newValue;
            }
            return null;
        }
        if (!oldValue.equals(newValue)) {
            this.releaseThisandParentDOM();
        }
        return newValue;
    }

    protected <T extends XMLObject> T prepareForAssignment(T oldValue, T newValue) {
        if (newValue != null && newValue.hasParent()) {
            throw new IllegalArgumentException(newValue.getClass().getName() + " cannot be added - it is already the child of another SAML Object");
        }
        if (oldValue == null) {
            if (newValue != null) {
                this.releaseThisandParentDOM();
                newValue.setParent(this);
                this.idIndex.registerIDMappings(newValue.getIDIndex());
                return newValue;
            }
            return null;
        }
        if (!oldValue.equals(newValue)) {
            oldValue.setParent(null);
            this.releaseThisandParentDOM();
            this.idIndex.deregisterIDMappings(oldValue.getIDIndex());
            if (newValue != null) {
                newValue.setParent(this);
                this.idIndex.registerIDMappings(newValue.getIDIndex());
            }
        }
        return newValue;
    }

    @Override
    public IDIndex getIDIndex() {
        return this.idIndex;
    }

    @Override
    public XMLObject resolveID(String id) {
        return this.idIndex.lookup(id);
    }

    @Override
    public XMLObject resolveIDFromRoot(String id) {
        XMLObject root = this;
        while (root.hasParent()) {
            root = root.getParent();
        }
        return root.resolveID(id);
    }

    protected void registerOwnID(String oldID, String newID) {
        String newString = DatatypeHelper.safeTrimOrNullString(newID);
        if (!DatatypeHelper.safeEquals(oldID, newString)) {
            if (oldID != null) {
                this.idIndex.deregisterIDMapping(oldID);
            }
            if (newString != null) {
                this.idIndex.registerIDMapping(newString, this);
            }
        }
    }
}

