/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import org.opensaml.xml.util.DatatypeHelper;

public class Namespace {
    private String namespaceURI;
    private String namespacePrefix;
    private boolean alwaysDeclare;
    private String nsStr;

    public Namespace() {
    }

    public Namespace(String uri, String prefix) {
        this.namespaceURI = DatatypeHelper.safeTrimOrNullString(uri);
        this.namespacePrefix = DatatypeHelper.safeTrimOrNullString(prefix);
        this.nsStr = null;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String newPrefix) {
        this.namespacePrefix = DatatypeHelper.safeTrimOrNullString(newPrefix);
        this.nsStr = null;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String newURI) {
        this.namespaceURI = DatatypeHelper.safeTrimOrNullString(newURI);
        this.nsStr = null;
    }

    public boolean alwaysDeclare() {
        return this.alwaysDeclare;
    }

    public void setAlwaysDeclare(boolean shouldAlwaysDeclare) {
        this.alwaysDeclare = shouldAlwaysDeclare;
    }

    public String toString() {
        if (this.nsStr == null) {
            this.constructStringRepresentation();
        }
        return this.nsStr;
    }

    public int hashCode() {
        String hashingString = this.toString() + Boolean.toString(this.alwaysDeclare);
        return hashingString.hashCode();
    }

    public boolean equals(Object obj) {
        Namespace otherNamespace;
        if (obj instanceof Namespace && (otherNamespace = (Namespace)obj).getNamespaceURI().equals(this.getNamespaceURI()) && otherNamespace.getNamespacePrefix().equals(this.getNamespacePrefix())) {
            return otherNamespace.alwaysDeclare() == this.alwaysDeclare();
        }
        return false;
    }

    protected void constructStringRepresentation() {
        StringBuffer stringRep = new StringBuffer();
        stringRep.append("xmlns");
        if (this.namespacePrefix != null) {
            stringRep.append(":");
            stringRep.append(this.namespacePrefix);
        }
        stringRep.append("=\"");
        if (this.namespaceURI != null) {
            stringRep.append(this.namespaceURI);
        }
        stringRep.append("\"");
        this.nsStr = stringRep.toString();
    }
}

