/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedType;
import org.opensaml.xml.encryption.EncryptionMethod;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteria;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.credential.KeyAlgorithmCriteria;
import org.opensaml.xml.security.credential.KeyLengthCriteria;
import org.opensaml.xml.security.credential.UsageCriteria;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.util.DatatypeHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decrypter {
    private final BasicParserPool parserPool;
    private UnmarshallerFactory unmarshallerFactory;
    private Logger log = Logger.getLogger(Decrypter.class);
    private KeyInfoCredentialResolver resolver;
    private KeyInfoCredentialResolver kekResolver;
    private EncryptedKeyResolver encKeyResolver;
    private CredentialCriteriaSet resolverCriteria;
    private CredentialCriteriaSet kekResolverCriteria;

    public Decrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver) {
        this.resolver = newResolver;
        this.kekResolver = newKEKResolver;
        this.encKeyResolver = newEncKeyResolver;
        this.resolverCriteria = null;
        this.kekResolverCriteria = null;
        this.parserPool = new BasicParserPool();
        this.parserPool.setNamespaceAware(true);
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        this.parserPool.setFeatures(features);
        this.unmarshallerFactory = Configuration.getUnmarshallerFactory();
    }

    public KeyInfoCredentialResolver getKeyResolver() {
        return this.resolver;
    }

    public void setKeyResolver(KeyInfoCredentialResolver newResolver) {
        this.resolver = newResolver;
    }

    public KeyInfoCredentialResolver getKEKResolver() {
        return this.kekResolver;
    }

    public void setKEKResolver(KeyInfoCredentialResolver newKEKResolver) {
        this.kekResolver = newKEKResolver;
    }

    public EncryptedKeyResolver getEncryptedKeyResolver() {
        return this.encKeyResolver;
    }

    public void setEncryptedKeyResolver(EncryptedKeyResolver newResolver) {
        this.encKeyResolver = newResolver;
    }

    public CredentialCriteriaSet setKeyResolverCriteria() {
        return this.resolverCriteria;
    }

    public void setKeyResolverCriteria(CredentialCriteriaSet newCriteria) {
        this.resolverCriteria = newCriteria;
    }

    public CredentialCriteriaSet getKEKResolverCriteria() {
        return this.kekResolverCriteria;
    }

    public void setKEKResolverCriteria(CredentialCriteriaSet newCriteria) {
        this.kekResolverCriteria = newCriteria;
    }

    public XMLObject decryptData(EncryptedData encryptedData) throws DecryptionException {
        return this.decryptData(encryptedData, false);
    }

    public XMLObject decryptData(EncryptedData encryptedData, boolean rootInNewDocument) throws DecryptionException {
        List<XMLObject> xmlObjects = this.decryptDataToList(encryptedData, rootInNewDocument);
        if (xmlObjects.size() != 1) {
            this.log.error((Object)"The decrypted data contained more than one top-level XMLObject child");
            throw new DecryptionException("The decrypted data contained more than one XMLObject child");
        }
        return xmlObjects.get(0);
    }

    public List<XMLObject> decryptDataToList(EncryptedData encryptedData) throws DecryptionException {
        return this.decryptDataToList(encryptedData, false);
    }

    public List<XMLObject> decryptDataToList(EncryptedData encryptedData, boolean rootInNewDocument) throws DecryptionException {
        LinkedList<XMLObject> xmlObjects = new LinkedList<XMLObject>();
        DocumentFragment docFragment = this.decryptDataToDOM(encryptedData);
        NodeList children = docFragment.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XMLObject xmlObject;
            Node node = children.item(i);
            if (node.getNodeType() != 1) {
                this.log.error((Object)("Decryption returned a top-level node that was not of type Element: " + node.getNodeType()));
                throw new DecryptionException("Top-level node was not of type Element");
            }
            Element element = (Element)node;
            if (rootInNewDocument) {
                Document newDoc = null;
                try {
                    newDoc = this.parserPool.newDocument();
                }
                catch (XMLParserException e) {
                    this.log.error((Object)"There was an error creating a new DOM Document", (Throwable)e);
                    throw new DecryptionException("Error creating new DOM Document", e);
                }
                newDoc.adoptNode(element);
                newDoc.appendChild(element);
            }
            try {
                xmlObject = this.unmarshallerFactory.getUnmarshaller(element).unmarshall(element);
            }
            catch (UnmarshallingException e) {
                this.log.error((Object)"There was an error during unmarshalling of the decrypted element", (Throwable)e);
                throw new DecryptionException("Unmarshalling error during decryption", e);
            }
            xmlObjects.add(xmlObject);
        }
        return xmlObjects;
    }

    public DocumentFragment decryptDataToDOM(EncryptedData encryptedData) throws DecryptionException {
        String algorithm;
        if (this.resolver == null && this.encKeyResolver == null) {
            this.log.error((Object)"Decryption can not be attempted, no key resolvers are set");
            throw new DecryptionException("Unable to decrypt EncryptedData, no key resolvers are set");
        }
        DocumentFragment docFrag = null;
        if (this.resolver != null) {
            docFrag = this.decryptUsingResolvedKey(encryptedData);
            if (docFrag != null) {
                return docFrag;
            }
            this.log.debug((Object)"Failed to decrypt EncryptedData using standard resolver");
        }
        if (DatatypeHelper.isEmpty(algorithm = encryptedData.getEncryptionMethod().getAlgorithm())) {
            String msg = "EncryptedData's EncryptionMethod Algorithm attribute was empty";
            this.log.error((Object)(msg + "key decryption could not be attempted"));
            throw new DecryptionException(msg);
        }
        if (this.encKeyResolver != null) {
            docFrag = this.decryptUsingResolvedEncryptedKey(encryptedData, algorithm);
            if (docFrag != null) {
                return docFrag;
            }
            this.log.debug((Object)"Failed to decrypt EncryptedData using EncryptedKeyResolver");
        }
        this.log.error((Object)"Failed to decrypt EncryptedData using either standard credential resolver or encrypted key resolver");
        throw new DecryptionException("Valid decryption key for EncryptedData could not be resolved");
    }

    public DocumentFragment decryptDataToDOM(EncryptedData encryptedData, Key dataEncKey) throws DecryptionException {
        XMLCipher xmlCipher;
        if (!"http://www.w3.org/2001/04/xmlenc#Element".equals(encryptedData.getType())) {
            this.log.error((Object)("EncryptedData was of unsupported type '" + encryptedData.getType() + "', could not attempt decryption"));
            throw new DecryptionException("EncryptedData of unsupported type was encountered");
        }
        if (dataEncKey == null) {
            this.log.error((Object)"Data decryption key was null");
            throw new IllegalArgumentException("Data decryption key may not be null");
        }
        try {
            this.checkAndMarshall(encryptedData);
        }
        catch (DecryptionException e) {
            this.log.error((Object)"Error marshalling EncryptedData for decryption", (Throwable)e);
            throw e;
        }
        Element targetElement = encryptedData.getDOM();
        try {
            xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, dataEncKey);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error initialzing cipher instance on data decryption", (Throwable)e);
            throw new DecryptionException("Error initialzing cipher instance on data decryption", (Exception)((Object)e));
        }
        byte[] bytes = null;
        try {
            bytes = xmlCipher.decryptToByteArray(targetElement);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error decrypting the encrypted data element", (Throwable)e);
            throw new DecryptionException("Error decrypting the encrypted data element", (Exception)((Object)e));
        }
        if (bytes == null) {
            throw new DecryptionException("EncryptedData could not be decrypted");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        DocumentFragment docFragment = this.parseInputStream(input, encryptedData.getDOM().getOwnerDocument());
        return docFragment;
    }

    public Key decryptKey(EncryptedKey encryptedKey, String algorithm) throws DecryptionException {
        if (this.kekResolver == null) {
            this.log.warn((Object)"No KEK KeyInfo credential resolver is available, can not attempt EncryptedKey decryption");
            throw new DecryptionException("No KEK KeyInfo resolver is available for EncryptedKey decryption");
        }
        if (DatatypeHelper.isEmpty(algorithm)) {
            this.log.error((Object)"Algorithm of encrypted key not supplied, key decryption cannot proceed.");
            throw new DecryptionException("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
        }
        CredentialCriteriaSet criteriaSet = this.buildCredentialCriteria(encryptedKey, this.kekResolverCriteria);
        try {
            for (Credential cred : this.kekResolver.resolve(criteriaSet)) {
                try {
                    return this.decryptKey(encryptedKey, algorithm, SecurityHelper.extractDecryptionKey(cred));
                }
                catch (DecryptionException e) {
                    String msg = "Attempt to decrypt EncryptedKey using credential from KEK KeyInfo resolver failed: ";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)msg, (Throwable)e);
                        continue;
                    }
                    this.log.warn((Object)(msg + e.getMessage()));
                }
            }
        }
        catch (SecurityException e) {
            this.log.error((Object)"Error resolving credentials from EncryptedKey KeyInfo", (Throwable)e);
        }
        this.log.error((Object)"Failed to decrypt EncryptedKey, valid decryption key could not be resolved");
        throw new DecryptionException("Valid decryption key for EncryptedKey could not be resolved");
    }

    public Key decryptKey(EncryptedKey encryptedKey, String algorithm, Key kek) throws DecryptionException {
        org.apache.xml.security.encryption.EncryptedKey encKey;
        XMLCipher xmlCipher;
        if (kek == null) {
            this.log.error((Object)"Data encryption key was null");
            throw new IllegalArgumentException("Data encryption key may not be null");
        }
        if (DatatypeHelper.isEmpty(algorithm)) {
            this.log.error((Object)"Algorithm of encrypted key not supplied, key decryption cannot proceed.");
            throw new DecryptionException("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
        }
        try {
            this.checkAndMarshall(encryptedKey);
        }
        catch (DecryptionException e) {
            this.log.error((Object)"Error marshalling EncryptedKey for decryption", (Throwable)e);
            throw e;
        }
        Element targetElement = encryptedKey.getDOM();
        try {
            xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(4, kek);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error initialzing cipher instance on key decryption", (Throwable)e);
            throw new DecryptionException("Error initialzing cipher instance on key decryption", (Exception)((Object)e));
        }
        try {
            encKey = xmlCipher.loadEncryptedKey(targetElement.getOwnerDocument(), targetElement);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error when loading library native encrypted key representation", (Throwable)e);
            throw new DecryptionException("Error when loading library native encrypted key representation", (Exception)((Object)e));
        }
        Key key = null;
        try {
            key = xmlCipher.decryptKey(encKey, algorithm);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error decrypting encrypted key", (Throwable)e);
            throw new DecryptionException("Error decrypting encrypted key", (Exception)((Object)e));
        }
        if (key == null) {
            throw new DecryptionException("Key could not be decrypted");
        }
        return key;
    }

    private DocumentFragment decryptUsingResolvedKey(EncryptedData encryptedData) {
        if (this.resolver != null) {
            CredentialCriteriaSet criteriaSet = this.buildCredentialCriteria(encryptedData, this.resolverCriteria);
            try {
                for (Credential cred : this.resolver.resolve(criteriaSet)) {
                    try {
                        return this.decryptDataToDOM(encryptedData, SecurityHelper.extractDecryptionKey(cred));
                    }
                    catch (DecryptionException e) {
                        String msg = "Decryption attempt using credential from standard KeyInfo resolver failed: ";
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)msg, (Throwable)e);
                            continue;
                        }
                        this.log.warn((Object)(msg + e.getMessage()));
                    }
                }
            }
            catch (SecurityException e) {
                this.log.error((Object)"Error resolving credentials from EncryptedData KeyInfo", (Throwable)e);
            }
        }
        return null;
    }

    private DocumentFragment decryptUsingResolvedEncryptedKey(EncryptedData encryptedData, String algorithm) {
        if (this.encKeyResolver != null) {
            for (EncryptedKey encryptedKey : this.encKeyResolver.resolve(encryptedData)) {
                try {
                    Key decryptedKey = this.decryptKey(encryptedKey, algorithm);
                    return this.decryptDataToDOM(encryptedData, decryptedKey);
                }
                catch (DecryptionException e) {
                    String msg = "Attempt to decrypt EncryptedData using key extracted from EncryptedKey failed: ";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)msg, (Throwable)e);
                        continue;
                    }
                    this.log.warn((Object)(msg + e.getMessage()));
                }
            }
        }
        return null;
    }

    private DocumentFragment parseInputStream(InputStream input, Document owningDocument) throws DecryptionException {
        Document newDocument = null;
        try {
            newDocument = this.parserPool.parse(input);
        }
        catch (XMLParserException e) {
            this.log.error((Object)"Error parsing decrypted input stream", (Throwable)e);
            throw new DecryptionException("Error parsing input stream", e);
        }
        Element element = newDocument.getDocumentElement();
        owningDocument.adoptNode(element);
        DocumentFragment container = owningDocument.createDocumentFragment();
        container.appendChild(element);
        return container;
    }

    private CredentialCriteriaSet buildCredentialCriteria(EncryptedType encryptedType, CredentialCriteriaSet staticCriteria) {
        CredentialCriteriaSet newCriteriaSet = new CredentialCriteriaSet();
        newCriteriaSet.add(new KeyInfoCriteria(encryptedType.getKeyInfo()));
        Set<CredentialCriteria> keyCriteria = this.buildKeyCriteria(encryptedType);
        if (keyCriteria != null && !keyCriteria.isEmpty()) {
            newCriteriaSet.addAll(keyCriteria);
        }
        if (staticCriteria != null && !staticCriteria.isEmpty()) {
            newCriteriaSet.addAll(staticCriteria);
        }
        if (!newCriteriaSet.contains(UsageCriteria.class)) {
            newCriteriaSet.add(new UsageCriteria(UsageType.ENCRYPTION));
        }
        return newCriteriaSet;
    }

    private Set<CredentialCriteria> buildKeyCriteria(EncryptedType encryptedType) {
        KeyLengthCriteria lengthCrit;
        EncryptionMethod encMethod = encryptedType.getEncryptionMethod();
        if (encMethod == null) {
            return Collections.emptySet();
        }
        String encAlgorithmURI = DatatypeHelper.safeTrimOrNullString(encMethod.getAlgorithm());
        if (encAlgorithmURI == null) {
            return Collections.emptySet();
        }
        HashSet<CredentialCriteria> critSet = new HashSet<CredentialCriteria>(2);
        KeyAlgorithmCriteria algoCrit = this.buildKeyAlgorithmCriteria(encAlgorithmURI);
        if (algoCrit != null) {
            critSet.add(algoCrit);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Added decryption key algorithm criteria: " + algoCrit.getKeyAlgorithm()));
            }
        }
        if ((lengthCrit = this.buildKeyLengthCriteria(encAlgorithmURI)) != null) {
            critSet.add(lengthCrit);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Added decryption key length criteria from EncryptionMethod algorithm URI: " + lengthCrit.getKeyLength()));
            }
        } else if (encMethod.getKeySize() != null && encMethod.getKeySize().getValue() != null) {
            lengthCrit = new KeyLengthCriteria(encMethod.getKeySize().getValue());
            critSet.add(lengthCrit);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Added decryption key length criteria from EncryptionMethod/KeySize: " + lengthCrit.getKeyLength()));
            }
        }
        return critSet;
    }

    private KeyAlgorithmCriteria buildKeyAlgorithmCriteria(String encAlgorithmURI) {
        if (DatatypeHelper.isEmpty(encAlgorithmURI)) {
            return null;
        }
        String jcaKeyAlgorithm = SecurityHelper.getKeyAlgorithmFromURI(encAlgorithmURI);
        if (!DatatypeHelper.isEmpty(jcaKeyAlgorithm)) {
            return new KeyAlgorithmCriteria(jcaKeyAlgorithm);
        }
        return null;
    }

    private KeyLengthCriteria buildKeyLengthCriteria(String encAlgorithmURI) {
        if (!DatatypeHelper.isEmpty(encAlgorithmURI)) {
            return null;
        }
        Integer keyLength = SecurityHelper.getKeyLengthFromURI(encAlgorithmURI);
        if (keyLength != null) {
            return new KeyLengthCriteria(keyLength);
        }
        return null;
    }

    protected void checkAndMarshall(XMLObject xmlObject) throws DecryptionException {
        Element targetElement = xmlObject.getDOM();
        if (targetElement == null) {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(xmlObject);
            try {
                targetElement = marshaller.marshall(xmlObject);
            }
            catch (MarshallingException e) {
                this.log.error((Object)"Error marshalling target XMLObject", (Throwable)e);
                throw new DecryptionException("Error marshalling target XMLObject", e);
            }
        }
    }

    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

