/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractXMLObjectUnmarshaller
implements Unmarshaller {
    private static Logger log = Logger.getLogger(AbstractXMLObjectUnmarshaller.class);
    private QName targetQName;
    private XMLObjectBuilderFactory xmlObjectBuilderFactory;
    private UnmarshallerFactory unmarshallerFactory;

    protected AbstractXMLObjectUnmarshaller() {
        this.xmlObjectBuilderFactory = Configuration.getBuilderFactory();
        this.unmarshallerFactory = Configuration.getUnmarshallerFactory();
    }

    protected AbstractXMLObjectUnmarshaller(String targetNamespaceURI, String targetLocalName) {
        this.targetQName = XMLHelper.constructQName(targetNamespaceURI, targetLocalName, null);
        this.xmlObjectBuilderFactory = Configuration.getBuilderFactory();
        this.unmarshallerFactory = Configuration.getUnmarshallerFactory();
    }

    public XMLObject unmarshall(Element domElement) throws UnmarshallingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting to unmarshall DOM element " + XMLHelper.getNodeQName(domElement)));
        }
        this.checkElementIsTarget(domElement);
        XMLObject xmlObject = this.buildXMLObject(domElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unmarshalling attributes of DOM Element " + XMLHelper.getNodeQName(domElement)));
        }
        NamedNodeMap attributes = domElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() != 2) continue;
            this.unmarshallAttribute(xmlObject, (Attr)attribute);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unmarshalling other child nodes of DOM Element " + XMLHelper.getNodeQName(domElement)));
        }
        NodeList childNodes = domElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 2) {
                this.unmarshallAttribute(xmlObject, (Attr)childNode);
                continue;
            }
            if (childNode.getNodeType() == 1) {
                this.unmarshallChildElement(xmlObject, (Element)childNode);
                continue;
            }
            if (childNode.getNodeType() != 3) continue;
            this.unmarshallTextContent(xmlObject, (Text)childNode);
        }
        xmlObject.setDOM(domElement);
        return xmlObject;
    }

    protected void checkElementIsTarget(Element domElement) throws UnmarshallingException {
        QName type;
        QName elementName = XMLHelper.getNodeQName(domElement);
        if (this.targetQName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Targeted QName checking is not available for this unmarshaller, DOM Element " + elementName + " was not verified"));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking that " + elementName + " meets target criteria."));
        }
        if ((type = XMLHelper.getXSIType(domElement)) != null && type.equals(this.targetQName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(elementName + " schema type matches target."));
            }
            return;
        }
        if (elementName.equals(this.targetQName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(elementName + " element name matches target."));
            }
            return;
        }
        String errorMsg = "This unmarshaller only operates on " + this.targetQName + " elements not " + elementName;
        log.error((Object)errorMsg);
        throw new UnmarshallingException(errorMsg);
    }

    protected XMLObject buildXMLObject(Element domElement) throws UnmarshallingException {
        XMLObjectBuilder xmlObjectBuilder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building XMLObject for " + XMLHelper.getNodeQName(domElement)));
        }
        if ((xmlObjectBuilder = this.xmlObjectBuilderFactory.getBuilder(domElement)) == null) {
            xmlObjectBuilder = this.xmlObjectBuilderFactory.getBuilder(Configuration.getDefaultProviderQName());
            if (xmlObjectBuilder == null) {
                String errorMsg = "Unable to located builder for " + XMLHelper.getNodeQName(domElement);
                log.error((Object)errorMsg);
                throw new UnmarshallingException(errorMsg);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("No builder was registered for " + XMLHelper.getNodeQName(domElement) + " but the default builder " + xmlObjectBuilder.getClass().getName() + " was available, using it."));
            }
        }
        return xmlObjectBuilder.buildObject(domElement);
    }

    protected void unmarshallAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        String attributeNamespace;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pre-processing attribute " + XMLHelper.getNodeQName(attribute)));
        }
        if (DatatypeHelper.safeEquals(attributeNamespace = DatatypeHelper.safeTrimOrNullString(attribute.getNamespaceURI()), "http://www.w3.org/2000/xmlns/")) {
            this.unmarshallNamespaceAttribute(xmlObject, attribute);
        } else if (DatatypeHelper.safeEquals(attributeNamespace, "http://www.w3.org/2001/XMLSchema-instance")) {
            this.unmarshallSchemaInstanceAttributes(xmlObject, attribute);
        } else {
            String attributeNSURI;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attribute " + XMLHelper.getNodeQName(attribute) + " is neither a schema type nor namespace, calling processAttribute()"));
            }
            if ((attributeNSURI = attribute.getNamespaceURI()) != null) {
                String attributeNSPrefix = attribute.lookupPrefix(attributeNSURI);
                Namespace attributeNS = new Namespace(attributeNSURI, attributeNSPrefix);
                attributeNS.setAlwaysDeclare(false);
                xmlObject.addNamespace(attributeNS);
            }
            this.checkIDAttribute(attribute);
            this.processAttribute(xmlObject, attribute);
        }
    }

    protected void unmarshallNamespaceAttribute(XMLObject xmlObject, Attr attribute) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(XMLHelper.getNodeQName(attribute) + " is a namespace declaration, adding it to the list of namespaces on the XMLObject"));
        }
        Namespace namespace = new Namespace(attribute.getValue(), attribute.getLocalName());
        namespace.setAlwaysDeclare(true);
        xmlObject.addNamespace(namespace);
    }

    protected void unmarshallSchemaInstanceAttributes(XMLObject xmlObject, Attr attribute) {
        if (!DatatypeHelper.safeEquals(attribute.getLocalName(), "type")) {
            if (DatatypeHelper.safeEquals(attribute.getLocalName(), "schemaLocation")) {
                xmlObject.setSchemaLocation(attribute.getValue());
            } else if (DatatypeHelper.safeEquals(attribute.getLocalName(), "noNamespaceSchemaLocation")) {
                xmlObject.setNoNamespaceSchemaLocation(attribute.getValue());
            }
        }
    }

    protected void checkIDAttribute(Attr attribute) {
        QName attribName = XMLHelper.getNodeQName(attribute);
        if (Configuration.isIDAttribute(attribName) && !attribute.isId()) {
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }

    protected void unmarshallChildElement(XMLObject xmlObject, Element childElement) throws UnmarshallingException {
        Unmarshaller unmarshaller;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unmarshalling child elements of XMLObject " + xmlObject.getElementQName()));
        }
        if ((unmarshaller = this.unmarshallerFactory.getUnmarshaller(childElement)) == null) {
            unmarshaller = this.unmarshallerFactory.getUnmarshaller(Configuration.getDefaultProviderQName());
            if (unmarshaller == null) {
                String errorMsg = "No unmarshaller available for " + XMLHelper.getNodeQName(childElement) + ", child of " + xmlObject.getElementQName();
                log.error((Object)errorMsg);
                throw new UnmarshallingException(errorMsg);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("No unmarshaller was registered for " + XMLHelper.getNodeQName(childElement) + ", child of " + xmlObject.getElementQName() + " but the default unmarshaller " + unmarshaller.getClass().getName() + " was available, using it."));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unmarshalling child element " + XMLHelper.getNodeQName(childElement) + " with unmarshaller " + unmarshaller.getClass().getName()));
        }
        this.processChildElement(xmlObject, unmarshaller.unmarshall(childElement));
    }

    protected void unmarshallTextContent(XMLObject xmlObject, Text content) throws UnmarshallingException {
        String textContent = DatatypeHelper.safeTrimOrNullString(content.getWholeText());
        if (textContent != null) {
            this.processElementContent(xmlObject, textContent);
        }
    }

    protected abstract void processChildElement(XMLObject var1, XMLObject var2) throws UnmarshallingException;

    protected abstract void processAttribute(XMLObject var1, Attr var2) throws UnmarshallingException;

    protected abstract void processElementContent(XMLObject var1, String var2);
}

